%
% function PLOT_TABLE(index).M
%

% Draw the fuzzy rule table of the index'th chromosome 

%index=1;

fs = 10;

%subplot(1,1,1);
x=1:7;
plot([0 7 7 0 0],[0 0 7 7 0],'k');
axis([0 7 0 7]);
axis off;
hold on;
fill([1 2 2 1],[0 0 5 5],[.7 .7 .7]);
fill([2 7 7 2],[5 5 6 6],[.7 .7 .7]);
plot([0 7],[5 5],'k');
for i=1:5;
   plot([1 7],[i i],'k');
   plot([i+2 i+2],[0 6],'k');
end;
plot([1 1],[0 4],'k');
plot([2 2],[0 7],'k');
plot([2 7],[6 6],'k');

text(4.57,7.10,'.','fontsize',20);
text(4.45,6.5,'e','fontname','times new roman','FontAngle','italic','fontsize',20);
text(.4,2.5,'e','fontname','times new roman','FontAngle','italic','fontsize',20);

text(2.25,5.5,'LN','fontsize',fs);
text(3.35,5.5,'N','fontsize',fs);
text(4.35,5.5,'Z','fontsize',fs);
text(5.35,5.5,'P','fontsize',fs);
text(6.25,5.5,'LP','fontsize',fs);

text(1.25,4.5,'LN','fontsize',fs);
text(1.35,3.5,'N','fontsize',fs);
text(1.35,2.5,'Z','fontsize',fs);
text(1.35,1.5,'P','fontsize',fs);
text(1.25,0.5,'LP','fontsize',fs);

% Rules
output_mf={'LN','N','Z','P','LP'};

%full_table = [chromosome chromosome(1,12:-1:1)+2*(3-chromosome(1,12:-1:1))];
full_table = [pop(1,:) pop(1,12:-1:1)+2*(3-pop(1,12:-1:1))];

for i = 1:5;
   for j=1:5;
      code = full_table(5*(i-1)+j);
      text(1.25+j+0.1*ismember(code,[2 3 4]),5.5-i,output_mf{code},'fontsize',fs);

   end;
end;

hold off;