% gfrule_mfplot.m 

e=linspace(-.8,.8,400);
ep=linspace(-.8,.8,400);

a=.4;
b=.1;
eLN=min(1,max(0,-(e+b)/(a-b)));
eN=max(0,min((e+a)/(a-b),-e/b));
eZ=max(0,1-abs(e)/b);
eP=max(0,min(-(e-a)/(a-b),e/b));
eLP=min(1,max(0,(e-b)/(a-b)));

a=.4;
b=.1;
epLN=min(1,max(0,-(ep+b)/(a-b)));
epN=max(0,min((ep+a)/(a-b),-ep/b));
epZ=max(0,1-abs(ep)/b);
epP=max(0,min(-(ep-a)/(a-b),ep/b));
epLP=min(1,max(0,(ep-b)/(a-b)));

subplot(3,1,1);
plot(e,eLN,'k',e,eN,'k',e,eZ,'k',e,eP,'k',e,eLP,'k','linewidth',2,'color',[.5 .5 .5]);
%title('Membership functions for e and e''')
axis([-.6 .6 0 1.2]);
ylabel('e','fontsize',16,'fontname','times new roman','FontAngle','italic');
text(-.43,.8,'LN');
text(-0.12,.8,'N');
text(-0.01,.8,'Z');
text(0.1,.8,'P');
text(0.40,.8,'LP');


subplot(3,1,2);
plot(ep,epLN,'k',ep,epN,'k',ep,epZ,'k',ep,epP,'k',ep,epLP,'k','linewidth',2,'color',[.5 .5 .5]);
axis([-.6 .6 0 1.2]);
ylabel('e','fontsize',16,'fontname','times new roman','FontAngle','italic');
text(-.7,.66,'.','FontSize',18)
text(-.43,.8,'LN');
text(-0.12,.8,'N');
text(-0.01,.8,'Z');
text(0.1,.8,'P');
text(0.40,.8,'LP');


subplot(3,1,3);out=[-4 -2 0 2 4];
for i=1:length(out);
   plot([out(i) out(i)],[0 1],'k','linewidth',3,'color',[.5 .5 .5]);
   hold on;
end;
hold off;
ylabel('u','fontsize',16,'fontname','times new roman','FontAngle','italic');
axis([-6 6 0 1.4]);
text(-5.3,1.2,'LN:1');
text(-2.3,1.2,'N:2');
text(-0.16,1.2,'Z:3');
text(1.7,1.2,'P:4');
text(4.5,1.2,'LP:5');