%
% gfrule.m

%clear all;

load input

global fuzzyrule;		% individual

iteration = 100;	% Number of iteration
popuSize = 30;		% Population size (multiple of 4)
p_c = 0.9;			% Crossover rate
p_m = 0.1;			% Mutation rate
var_n = 13;			% Number of element in a chromosome ( # of rules )

sim_time = 40;

output = [-4 -2 0 2 4];	

%-------------------------------------------------------
% Initialize random population 
if upper(input('Generate initial population?  Y or N : ','s')) == 'Y'
   
   pop = ceil(rand(popuSize,var_n)*5);
   %pop = 5*(2*rand(popuSize,var_n)-1);
   fitness = zeros(popuSize, 1); % Fitness vector

  	%------------------------------------------------------------
   % Evaluate objective function(fitness) for each individual
   %------------------------------------------------------------
   for j = 1:popuSize,
      fuzzyrule = output(pop(j,:));  
      %fuzzyrule = pop(j,:);
      if mod(j,5)==0;fprintf('%i ',j);end;
  		fitness(j) = gfrule_fit('sl_slc',[0 sim_time],0);  % fitness evalution w/o plotting
   end;   
   gen = 1;
   
   % Fill objective function matrices
	[best,idx] = max(fitness);
	average = mean(fitness);
   poorest = min(fitness);
   
   % put the best chromosome at the top
   temp = pop(idx,:);pop(idx,:)=pop(1,:);pop(1,:)= temp;
   temp = fitness(idx);fitness(idx)=fitness(1);fitness(1)=temp;
   
end;
% END Initialize random population 
%-------------------------------------------------------



%---------------------------------------------------------
% Main loop of GA
%---------------------------------------------------------
for i = 1:iteration;
   
   %------------------------------------------------------------
   % Evaluate objective function(fitness) for each individual
   % and sort in descending order of the fitness
   %------------------------------------------------------------
   if gen == length(best)+1; % check for the existence of fitness 
      for j = 1:popuSize,  
   	   fuzzyrule = output(pop(j,:));    
	      %fuzzyrule = pop(j,:);
      	if mod(j,5)==0;fprintf('%i ',j);end;
         fitness(j) = gfrule_fit('sl_slc',[0 sim_time],0);  % fitness evalution w/o plotting
      end;
      
      % Fill objective function matrices
      best = [best max(fitness)];
      average = [average mean(fitness)];     
      poorest = [poorest min(fitness)];
   end;
   
    %--------------------------------------------------------------
   % display current best
   %--------------------------------------------------------------
   [maxfit,idx]=max(fitness);
   fuzzyrule = output(pop(idx,:));  
   %fuzzyrule = pop(idx,:);
   fprintf('Generation :%i, fitness : %f\n',gen,maxfit);
   if mod(gen,1)==0
      figure(1);
      gfrule_surf;
      pause(0);
      %figure(2);
      %plot_table;
      figure(3);
      x = (1:length(best))';
		plot(x, best, 'o', x, average, 'x', x, poorest, '*');hold on;
		plot(x, [best' average' poorest']);hold off;
   end;
    
   if mod(gen,10)==0;
      save population;
   end;
   
   %----------------------------------------------------------------
   % generate next population via mutation
   %----------------------------------------------------------------
   new_pop = pop;
   
   	%-------------------------------------------------------------
		% ELITISM: find the best two and keep them
		%-------------------------------------------------------------
		tmp_fitness = fitness;
		[junk, index1] = max(tmp_fitness);	% find the best
		tmp_fitness(index1) = min(tmp_fitness);
		[junk, index2] = max(tmp_fitness);	% find the second best
      %new_pop([1 2], :) = pop([index1 index2], :);

      % rescaling the fitness
		cum_prob = cumsum(fitness/sum(fitness));

		%----------------------------------------------
		%  SELECTION and CROSSOVER
		%----------------------------------------------
		for j = 1:popuSize/2-1,
			% === Select two parents based on their scaled fitness values
			tmp = find(cum_prob - rand > 0);
			parent1 = pop(tmp(1), :);
			tmp = find(cum_prob - rand > 0);
			parent2 = pop(tmp(1), :);
			% === Do crossover
	         if rand < p_c,
               r=ceil(rand*var_n);
               new_pop(j+2,:)=[parent1(1:r) parent2(r+1:var_n)];
		 			new_pop(j+1+popuSize/2,:)=[parent2(1:r) parent1(r+1:var_n)];
  		   	end
		end

		%------------------------------------------------------
		%  MUTATION (elites are not subject to this.)
		%------------------------------------------------------
      if 1;
      mask = rand(popuSize,var_n) < 1*p_m;
      new_pop= ~mask.*new_pop+5*mask.*rand(popuSize,var_n);
      mask = rand(popuSize,var_n) < 1*p_m;
      new_pop = new_pop+(2*round(rand(popuSize,var_n))-1);
      
      new_pop = new_pop.*~(new_pop>5)+5*(new_pop>5);
      new_pop = new_pop.*~(new_pop<1)+(new_pop<1);
   	end;
   
   	if 0;
      mask = rand(popuSize,var_n) < 1*p_m;
      new_pop= ~mask.*new_pop+5*mask.*(2*(rand(popuSize,var_n))-1);
      mask = rand(popuSize,var_n) < 1*p_m;
      new_pop = new_pop+(2*(rand(popuSize,var_n))-1);
      
      new_pop = new_pop.*~(new_pop>5)+5*(new_pop>5);
      new_pop = new_pop.*~(new_pop<-5)-5*(new_pop<-5);
		end;

   
      
      new_pop([1 2], :) = pop([index1 index2], :); % keep two elites

             
	% new population
   	pop = ceil(new_pop);   
      %pop = new_pop;
      gen = gen + 1;
      if mod(gen,10)==0;save population;end;
end



% Plot the evolution of generations
figure(3);
x = (1:length(best))';
plot(x, best, 'o', x, average, 'x', x, poorest, '*');
hold on;
plot(x, [best' average' poorest']);
hold off;
legend('Best', 'Average', 'Poorest');
xlabel('Generations'); ylabel('Fitness');


