% gfmf_fis.m 

function y = gfmf_fis(e);

global fuzzyrule;
global chromosome;

a=chromosome(2);
b=chromosome(1);
eLN=min(1,max(0,-(e(1)+b)/(a-b)));
eN=max(0,min((e(1)+a)/(a-b),-e(1)/b));
eZ=max(0,1-abs(e(1))/b);
eP=max(0,min(-(e(1)-a)/(a-b),e(1)/b));
eLP=min(1,max(0,(e(1)-b)/(a-b)));

a=chromosome(4);
b=chromosome(3);
epLN=min(1,max(0,-(e(2)+b)/(a-b)));
epN=max(0,min((e(2)+a)/(a-b),-e(2)/b));
epZ=max(0,1-abs(e(2))/b);
epP=max(0,min(-(e(2)-a)/(a-b),e(2)/b));
epLP=min(1,max(0,(e(2)-b)/(a-b)));


r =[
   eLN*epLN
   eLN*epN
   eLN*epZ
   eLN*epP
   eLN*epLP
   eN*epLN
   eN*epN
   eN*epZ
   eN*epP
   eN*epLP
   eZ*epLN
   eZ*epN
   eZ*epZ
   eZ*epP
   eZ*epLP
   eP*epLN
   eP*epN
   eP*epZ
   eP*epP
   eP*epLP
   eLP*epLN
   eLP*epN
   eLP*epZ
   eLP*epP
   eLP*epLP
];

sm = sum(r);
if sm == 0; y = 0;
else y = fuzzyrule*r/sm*0.017453;  % pi/180 = 0.17453
end
