% gfmod_sym_mfplot.m
function gamod_sym_mfplot(output_range,text_flag)
%chrom=cell(1,3);
%chrom{1}=[1.09 0;1.2 0.27; 0.79 0.19;0.75 0.52;.74 .57];
%chrom{2}=[-6.4 8.9 6 1 40 3 1 3 40.4;-3.1 0.44 10 2 50 9 19 5.3 56.7;...
%      0.53 2.07 0.5 6.72 46.3 2.13 0.1 1.2 45.83;...
%      -0.7 0.05 3 4.72 60.4 3.23 5.4 4.7 59.54;...
%      -1.1 2.19 0.05 1.32 54.5 3.44 7.8 4.3 57.33];
%chrom{3}=25.34;

global chrom;

fs = 10;

omax = output_range(2);
omin = output_range(1);

clf;

dim=size(chrom{1});
for i = 1:dim(1)
   for j = 1:dim(2)
      if chrom{1}(i,j)
      	subplot(dim(1)*2,dim(2)+1,(dim(2)+1)*2*(i-1)+j);
      	c = chrom{2}(i,4*(j-1)+1);
      	d = chrom{2}(i,4*(j-1)+2);
      	l = chrom{2}(i,4*(j-1)+3);
      	r = chrom{2}(i,4*(j-1)+4);
      	span=linspace(l,r,200);hold on;
      	a=max(0,min(1,min((span-l)/(c-l-d),(span-r)/(c+d-r))));
      	plot(span,a,'LineWidth',2);
       
      	%plot(span,a*chrom{1}(i,j));
      	plot([(r+l)/2-.7*(r-l) (r+l)/2+.7*(r-l)],[0 0],'k','LineWidth',2);
      	plot([c c],[0 1],'k:')
      	if text_flag
      	text(c-(r-l)/10,-0.1,num2str(c,2),'fontsize',fs);
      	text(c,1.1,num2str(d,2),'fontsize',fs);
      	text(l-(r-l)/10,-.1,num2str(l,2),'fontsize',fs);
      	text(r,-.1,num2str(r,2),'fontsize',fs);
      	%text(c-(r-l)/10,0.5,num2str(chrom{1}(i,j),2),'fontsize',fs,'Color','r');
      	end;
      	axis([(r+l)/2-.7*(r-l) (r+l)/2+.7*(r-l) 0 1.2]);
      	axis off; hold off;
      
      	subplot(dim(1)*2,dim(2)+1,(dim(2)+1)*(2*i-1)+j);
      	span=linspace(-r,-l,200);hold on;
      	a=max(0,min(1,min((span+l)/(l+d-c),(span+r)/(r-c-d))));
      	plot(span,a,'LineWidth',2);
      	%plot(span,a*chrom{1}(i,j));
      	plot([-(r+l)/2-.7*(r-l) -(r+l)/2+.7*(r-l)],[0 0],'k','LineWidth',2);
      	plot([-c -c],[0 1],'k:')
      	if text_flag
      	text(-c-(r-l)/10,-0.1,num2str(-c,2),'fontsize',fs);
      	text(-c,1.1,num2str(d,2),'fontsize',fs);
      	text(-r-(r-l)/8,-.1,num2str(-r,2),'fontsize',fs);
      	text(-l,-.1,num2str(-l,2),'fontsize',fs);
      	%text(-c-(r-l)/10,0.5,num2str(chrom{1}(i,j),2),'fontsize',fs,'Color','r');
      	end;
      	axis([-(r+l)/2-.7*(r-l) -(r+l)/2+.7*(r-l) 0 1.2]);
      	axis off; hold off;
    	end; 
   end;
end;

for k = 1:dim(1);
   subplot(dim(1)*2,dim(2)+1,(dim(2)+1)*(2*k-1));hold on;
   o = chrom{1,2}(k,4*dim(2)+1);
   plot(o*[1 1], [0 1],'LineWidth',2);
   %plot([omin-.2*(omax-omin) omax+.2*(omax-omin)],[0 0],'k','LineWidth',2);
   plot([omin omax],[0 0],'k','LineWidth',2);
   text(o-(omax-omin)/10,-0.1,num2str(o,2),'fontsize',fs);
   axis([omin omax 0 1.2]);
   axis off; hold off;
   
   subplot(dim(1)*2,dim(2)+1,(dim(2)+1)*2*k);hold on;
   o = -o;
   plot(o*[1 1], [0 1],'LineWidth',2);
   %plot([omin-.2*(omax-omin) omax+.2*(omax-omin)],[0 0],'k','LineWidth',2);
   plot([omin omax],[0 0],'k','LineWidth',2);
   text(o-(omax-omin)/10,-0.1,num2str(o,2),'fontsize',fs);
   axis([omin omax 0 1.2]);
   axis off; hold off;

end;