% gfmod_sym_fis.m 

function [y,ci] = gamod_fis(x);

global chrom;

dim=size(chrom{1});

w1=1;
w2=1;
ci=0;
sum_w=0;
sum_wB=0;

for i = 1:dim(1);
   w1=1;
   w2=1;
   for j = 1:dim(2);
      c = chrom{2}(i,4*(j-1)+1);
      d = chrom{2}(i,4*(j-1)+2);
      l = chrom{2}(i,4*(j-1)+3);
      r = chrom{2}(i,4*(j-1)+4);
      if chrom{1}(i,j) ~= 0;
         
      w1 = w1*max(0,min(1,min((x(j)-l)/(c-l-d),(x(j)-r)/(c+d-r))))...
         *chrom{1}(i,j);
      w2 = w2*max(0,min(1,min((x(j)+l)/(l+d-c),(x(j)+r)/(r-c-d))))...
         *chrom{1}(i,j);
      end;
   end;
   ci = ci | (w1 == 0) | (w2 == 0);
   sum_w = sum_w + w1 + w2;
   sum_wB = sum_wB + (w1-w2)*chrom{2}(i,4*dim(2)+1);
end;

if sum_w ~=0;
   y = sum_wB/sum_w*pi/180;
else y = 0;   
end;