% GFMOD_INIT_POPU.M

function pop = gfmod_init_popu(popuSize,no_input,no_output,max_rule,range);

pop = cell(popuSize,2);

for i = 1 : popuSize
   
   %-------------------------------------------------------------------
   % BEGIN 		Generate random rule matrix 
   
   no_rule = ceil(rand*(max_rule));			% number of rules
   pop{i,1}=rand(no_rule,no_input)>.2;		% generate random rule mat
   zerorow = find(sum(pop{i,1},2)==0);		% find zero row
   pop{i,1}(zerorow,:)=1;					% fix zero row
   
   % END		Generate random rule matrix   
   %-------------------------------------------------------------------
   
   
   %-------------------------------------------------------------------
   % BEGIN		Generate random parameter matrix
   
   pop{i,2}= zeros(no_rule,4*no_input+1); 
   for j = 1 : no_rule;
      for k = 1 : no_input;
         min_in = range(k,1);
         max_in = range(k,2);
         c = rand*(max_in-min_in)+min_in;
         pop{i,2}(j,4*(k-1)+1)=c;
         d = rand*min(max_in-c,c-min_in);
         pop{i,2}(j,4*(k-1)+2) = d;
         pop{i,2}(j,4*(k-1)+3) = min_in+rand*(c-min_in-d);
         pop{i,2}(j,4*(k-1)+4) = max_in-rand*(max_in-c-d);
      end;
      pop{i,2}(j,4*no_input+1) = range(no_input+1,1)+...
                          rand*(range(no_input+1,2)-range(no_input+1,1));
    end;         
    
    % END   Generate random parameter matrix
    %--------------------------------------------------------------------
    
end;