%
% 	GFMOD.M 
%
% 	needed file 'gfmod_init_popu.m' 'gfmod_fit_eval' 'gfmod_sym_mfplot'


% Parameter initialization

global chrom;		% individual

sim_time = 40;

iteration = 97;	% Number of iteration
popuSize = 30;		% Population size (multiple of 5)
no_input = 2;		% Number of input
no_output = 1;		% Number of output
p_str = 0.1;		% Mutation rate for structure
p_par = 0.1;		% Mutation rate for parameters
max_rule = 10;

ranges = [-10 10;-10 10;-5 5];	% Range of the input and output variables

ai = [(ranges(1,2)-ranges(1,1)) (ranges(2,2)-ranges(2,1))]/15;
ao = (ranges(3,2)-ranges(3,1))/15;


%-------------------------------------------------------
% BEGIN	Initialize random population 

if upper(input('Generate initial population?  Y or N : ','s')) == 'Y'
   pop = gfmod_init_popu(popuSize,no_input,no_output,max_rule,ranges);
   
   fitness = zeros(popuSize, 1); % Fitness vector
   
    % Evaluate fitness for each individual and sort in descending order
   for j = 1:popuSize,
      chrom = pop(j, :);
      % fitness evalution w/o plotting
      fitness(j) = gfmod_fit_eval('sl_slc',[0 sim_time],size(chrom{2},1),0);  
   end;   
   
   gen = 1;

   % Sort population in the descending order of the fitness
   [fitness,sort_idx]=sort(fitness);
   fitness = fitness(popuSize:-1:1);
   sort_idx = sort_idx(popuSize:-1:1);
   pop=pop(sort_idx,:);
   
   % Fill objective function matrices
   best = max(fitness);
   average = mean(fitness);
   lower = min(fitness);

end;

% END Initialize random population 
%---------------------------------------------------------------


%---------------------------------------------------------
%
% Main loop of GA
%

for i = 1:iteration;
   
      % Evaluate fitness for each individual and sort in descending order
      if gen == length(best)+1; 	% check for the existence of fitness 
      for j = 1:popuSize,
         chrom = pop(j,:);        
         % fitness evalution w/o plotting
         fitness(j) = gfmod_fit_eval('sl_slc',[0 sim_time],size(chrom{2},1),0);  
      end;
      
      % Sort population in the descending order of the fitness
      [fitness,sort_idx]=sort(fitness);
      fitness = fitness(popuSize:-1:1);
      sort_idx = sort_idx(popuSize:-1:1);
      pop=pop(sort_idx,:);
      
      % Fill objective function matrices
      best = [best max(fitness)];
      average = [average mean(fitness)];     
      lower = [lower min(fitness)];
   end;
   
   %--------------------------------------------------------------
   % display current best
   %--------------------------------------------------------------
   chrom = pop(1,:);  
   fprintf('Generation :%i, fitness : %f\n',gen,fitness(1));
   if mod(gen,1)==0
      figure(1);
      gfmod_sym_mfplot(ranges(no_input,:),0);
      pause(0);
      figure(2);
      gfmod_surf;
      figure(3);
      x = (1:length(best))';
		plot(x, best, 'o', x, average, 'x', x, lower, '*');hold on;
		plot(x, [best' average' lower']);hold off;
   end;
   if mod(gen,10)==0;save population;end;
   
   %----------------------------------------------------------------
   % Reproduction
   %----------------------------------------------------------------
   new_pop = pop;
   
  	%------------------------------------------------------
      %  MUTATION: on only the lower 80%
      %------------------------------------------------------
      for k = 1:popuSize/5;
         for l = 1:4
            
            % Rule matrix mutation
            % inclusion index mutation
            dim = size(pop{k,1});
            mu_flag = rand(dim) < p_str;
            new_pop{l*popuSize/5+k,1}=pop{k,1}.*~mu_flag+~pop{k,1}.*mu_flag;
               
            % parameter mutation
            dimp = size(pop{k,2});
            mu_flag = rand(dimp) < p_par;
            new_pop{l*popuSize/5+k,2}=pop{k,2}+exp(1-fitness(k)/fitness(1))...
                       *[kron(ai,ones(dimp(1),4))';ao*ones(1,dimp(1))]'.*randn(dimp).*mu_flag;            
                    
             %---------------------------------------------------------------
             % BEGIN    correct any illegal element of the parameter matrix 
                    
             for q = 1:no_input;
               temp = new_pop{l*popuSize/5+k,2}(:,1+4*(q-1):4*q);
               co_flag_d = temp(:,2) < 0;
               temp(:,2) = temp(:,2).*~co_flag_d;
               co_flag_l = temp(:,1)-temp(:,2) < temp(:,3);
               temp(:,3) = temp(:,3).*~co_flag_l+(temp(:,1)-temp(:,2)-0.001).*co_flag_l;
               co_flag_r = temp(:,1)+temp(:,2) > temp(:,4);
               temp(:,4) = temp(:,4).*~co_flag_r+(temp(:,1)+temp(:,2)+0.001).*co_flag_r;
					new_pop{l*popuSize/5+k,2}(:,1+4*(q-1):4*q) = temp;
            end;
            temp = new_pop{l*popuSize/5+k,2}(:,4*no_input+1);
				co_flag_over = temp > ranges(no_input+1,2);
				temp = temp.*~co_flag_over+ranges(no_input+1,2)*co_flag_over;
            co_flag_under = temp < ranges(no_input+1,1);
            temp = temp.*~co_flag_under+ranges(no_input+1,1)*co_flag_under;
            new_pop{l*popuSize/5+k,2}(:,4*no_input+1) = temp;           
            
            % END 		correct any illegal element of the parameter matrix 
            %-----------------------------------------------------------------------
            
            %-----------------------------------------------------------------------
            % BEGIN		# of rules mutation
            
            chg_rule = (rand<p_str)*round(randn*max_rule/12);                    
            
            if (dim(1)+chg_rule > 1)*(chg_rule < 0)  % reduce rule : remove rows randomly
               for m = 1 : abs(chg_rule);
                  row = size(new_pop{l*popuSize/5+k,1},1);
                  row_rmv = ceil(rand*row);
                  remain_vec=[];
                  for p = 1 : row;
                     if p ~= row_rmv;
                        remain_vec = [remain_vec p];
                     end;
                  end;
                  new_pop{l*popuSize/5+k,1}=new_pop{l*popuSize/5+k,1}(remain_vec,:);
                  new_pop{l*popuSize/5+k,2}=new_pop{l*popuSize/5+k,2}(remain_vec,:);
               end;
            elseif (dim(1)+chg_rule < max_rule+1)*(chg_rule > 0);  % increase rule
            
                % add random rows to rule matrix
  			new_pop{l*popuSize/5+k,1}=[pop{k,1}; rand(chg_rule,no_input)>.2];
			zerorow = find(sum(new_pop{l*popuSize/5+k,1},2)==0);		% find zero row
   			new_pop{l*popuSize/5+k,1}(zerorow,:)=1; 					% fix zero row
                % add random rows to parameter matrix
               new_pop{l*popuSize/5+k,2}=[pop{k,2}; zeros(chg_rule,no_input*4+no_output)];
               for s = dim(1)+1 : dim(1)+chg_rule;             
                  for q = 1 : no_input;
                     min_in = ranges(q,1); 
                     max_in = ranges(q,2);
                     c = rand*(max_in-min_in)+min_in;
                     new_pop{l*popuSize/5+k,2}(s,4*(q-1)+1)=c;
                     d = rand*min(max_in-c,c-min_in); 
                     new_pop{l*popuSize/5+k,2}(s,4*(q-1)+2) = d;
                     new_pop{l*popuSize/5+k,2}(s,4*(q-1)+3) = min_in+rand*(c-min_in-d);
                     new_pop{l*popuSize/5+k,2}(s,4*(q-1)+4) = max_in-rand*(max_in-c-d);                   
                  end; 
                  new_pop{l*popuSize/5+k,2}(s,4*no_input+1) = ranges(no_input+1,1)+...
                                             rand*(ranges(no_input+1,2)-ranges(no_input+1,1));    
               end; 
               % END 	# of rules mutation
               %-----------------------------------------------------------------------
               
            end;       
         end;
      end;		% END mutation loop (k)        
      
	% new population
	pop = new_pop;   
	gen = gen+1;
	      
end 

% END 		main loop of GA (i) 
%------------------------------------------------------------------------------------
   
% Plot the evolution of generations
figure(3);
x = (1:length(best))';
plot(x, best, 'o', x, average, 'x', x, lower, '*');
hold on;
plot(x, [best' average' lower']);
hold off;
legend('Best', 'Average', 'Poorest');
xlabel('Generations'); ylabel('Fitness');


