function [lambda] = dict_compr_mmi2_est(D, data, label, N, T, kOpt);
% For supervised MMI case, auto-estimate the parameter to regularize the 
% emphasis on appearance or label (experimental)

% D: init dictionary
% data: input signals used to obtain D
% N: number of dictionary atoms to be selected
% T: sparsity 
% kOpt: GP kernel option
%
% lambda: parameter to regularize the emphasis on appearance or label 

% Sam Q. Qiu (qiu@cs.umd.edu)
% Feb. 2011
%
% Reference:
%  Qiang Qiu, Zhuolin Jiang, and Rama Chellappa, "Sparse Dictionary-based
%  Representation and Recognition of Human Action Attributes", International
%  Conference on Computer Vision (ICCV) 2011


X = omp(D'*data,D'*D,T);

N_dict=size(D,2); % number of dictionary items
N_class=length(unique(label)); % number of class
classid = unique(label);

p_y_d = zeros (N_dict, N_class); % P(Y|D)

for cid=1:N_class % class id
    idx = find(label==classid(cid));
    for did=1:N_dict % dictionary item id
        p_y_d(did, cid) = sum(abs(X(did, idx)))/length(idx)+eps;
    end
end

p_y_d = p_y_d./repmat(sum(p_y_d, 2), 1, size(p_y_d, 2));
p_d =sum(abs(X), 2)/ sum(sum(abs(X), 2)) +eps; % P(D)

if kOpt==1
    K= cov(full(X'));
else
    K= cov(full(D)); % Alternative GP kernel (slower)
end

K(find(abs(K)<mean(mean(abs(K)))))=0; % truncation for fast computation

A=[];
NA=[1:size(D,2)]';
maxIM_set=[];


if N_dict==N
    Dcompr = D;
    return;
end

maxIM1 = -inf;
maxIM2 = -inf;


maxIM = -inf;
for i=1:size(D,2)
    if ismember(i, A)
        continue;
    end
    
    if isempty(A)
        sigma1 = K(i,i);
        H1 =.5*log2(2*pi*exp(1)*sigma1);
        p1= p_y_d(i,:);
        HY1 = (-1)*sum(p1.*log2(p1));
    else
        idx1 = find(K(i,A)~=0);
        sigma1=K(i,i) - K(i,A(idx1))*inv(K(A(idx1),A(idx1)))*K(A(idx1),i);
        if(abs(sigma1)<1e-6)
            H1=0;
        else
            H1 =.5*log2(2*pi*exp(1)*sigma1);
        end
        
        p1= p_y_d(i,:);
        p2=sum(p_y_d(A, :), 1);
        p2 = p2./sum(p2);
        
        HY1 = -sum(p1.*p2.*log2(p1));
    end
    
    if isempty(NA)
        sigma2 = K(i,i);
        H2=.5*log2(2*pi*exp(1)*sigma2);
        p1= p_y_d(i,:);
        HY2 = (-1)*sum(p1.*log2(p1));
    else
        NA(find(NA==i))=[];
        
        idx2 = find(K(i,NA)~=0);
        sigma2=K(i,i) - K(i,NA(idx2))*inv(K(NA(idx2),NA(idx2)))*K(NA(idx2),i);
        if(abs(sigma2)<1e-6)
            H2=0;
        else
            H2=.5*log2(2*pi*exp(1)*sigma2);
        end
        
        p1= p_y_d(i,:);
        p2=sum(p_y_d(NA, :), 1);
        p2 = p2./sum(p2);
        HY2 = -sum(p1.*p2.*log2(p1));
    end
    
    
    if real(H1-H2) > maxIM1
        maxIM1 = real(H1-H2);
    end
    if real(HY1-HY2) > maxIM2
        maxIM2 = real(HY1-HY2);
    end
end


maxIM=[maxIM1 maxIM2];
lambda = maxIM(1)./maxIM(2);
