function [Dcompr] = dict_compr_mmi2(D, data, label, N, T, lambda, kOpt);
% supervised MMI (MMI2) dictionary atom selection

% D: init dictionary
% data: input signals used to obtain D
% label: class label for input signals
% N: number of dictionary atoms to be selected
% T: sparsity
% lambda: parameter to regularize the emphasis on appearance or label
% kOpt: GP kernel option

% Dcompr: compressed dictionary of N atoms

% Sam Q. Qiu (qiu@cs.umd.edu)
% Feb. 2011
%
% Reference:
%  Qiang Qiu, Zhuolin Jiang, and Rama Chellappa, "Sparse Dictionary-based
%  Representation and Recognition of Human Action Attributes", International
%  Conference on Computer Vision (ICCV) 2011

ttt=cputime;
% lambda = 1;

X = omp(D'*data,D'*D,T);

N_dict=size(D,2); % number of dictionary items
N_class=length(unique(label)); % number of class
classid = unique(label);

p_y_d = zeros (N_dict, N_class); % P(Y|D)

for cid=1:N_class % class id
    idx = find(label==classid(cid));
    for did=1:N_dict % dictionary atom id
        p_y_d(did, cid) = sum(abs(X(did, idx)))/length(idx)+eps;
    end
end

p_y_d = p_y_d./repmat(sum(p_y_d, 2), 1, size(p_y_d, 2));
p_d =sum(abs(X), 2)/ sum(sum(abs(X), 2)) +eps; % P(D)


if kOpt==1
    K= cov(full(X'));
else
    K= cov(full(D)); % Alternative GP kernel (slower)
end

K(find(abs(K)<mean(mean(abs(K)))))=0; % truncation for fast computation

A=[];
NA=[1:size(D,2)]';
maxIM_set=[];

if N_dict==N
    Dcompr = D;
    return;
end

for iter=1:N
    maxIM = -inf;
    for i=1:size(D,2)
        if ismember(i, A)
            continue;
        end
        
        if isempty(A)
            sigma1 = K(i,i);
            H1 =.5*log2(2*pi*exp(1)*sigma1);
            p1= p_y_d(i,:);
            HY1 = (-1)*sum(p1.*log2(p1));
        else
            idx1 = find(K(i,A)~=0);
            sigma1=K(i,i) - K(i,A(idx1))*inv(K(A(idx1),A(idx1)))*K(A(idx1),i);
            if(abs(sigma1)<1e-6)
                H1=0;
            else
                H1 =.5*log2(2*pi*exp(1)*sigma1);
            end
            
            p1= p_y_d(i,:);
            p2=sum(p_y_d(A, :), 1);
            p2 = p2./sum(p2);
            HY1 = -sum(p1.*p2.*log2(p1));
        end
        
        if isempty(NA)
            sigma2 = K(i,i);
            H2=.5*log2(2*pi*exp(1)*sigma2);
            p1= p_y_d(i,:);
            HY2 = (-1)*sum(p1.*log2(p1));
        else
            NA(find(NA==i))=[];
            
            idx2 = find(K(i,NA)~=0);
            sigma2=K(i,i) - K(i,NA(idx2))*inv(K(NA(idx2),NA(idx2)))*K(NA(idx2),i);
            if(abs(sigma2)<1e-6)
                H2=0;
            else
                H2=.5*log2(2*pi*exp(1)*sigma2);
            end
            
            p1= p_y_d(i,:);
            p2=sum(p_y_d(NA, :), 1);
            p2 = p2./sum(p2);
            HY2 = -sum(p1.*p2.*log2(p1));
        end
        
        IM = (H1-H2) +  lambda*(HY1-HY2);
        
        NA=[NA;i];
        
        if IM > maxIM
            maxIM = IM;
            s = i;
        end
    end
    A=[A; s];
    
    NA(find(NA==s))=[];
end

Dcompr = D(:,A);

ctime = cputime-ttt;
fprintf(1,'(MMI2) Dictionary compressed from %d to %d in %f sec\n',N_dict, N, ctime);
