function [Dcompr] = dict_compr_me(D, data, N, T, kOpt);
% Max. Entropy dictionary atom selection

% D: init dictionary
% data: input signals used to obtain D
% N: number of dictionary atoms to be selected
% T: sparsity
% kOpt: GP kernel option

% Dcompr: compressed dictionary of N atoms

% Sam Q. Qiu (qiu@cs.umd.edu)
% Feb. 2011
%
% Reference:
%  Qiang Qiu, Zhuolin Jiang, and Rama Chellappa, "Sparse Dictionary-based
%  Representation and Recognition of Human Action Attributes", International
%  Conference on Computer Vision (ICCV) 2011

X = omp(D'*data,D'*D,T);

N_dict=size(D,2); % number of dictionary items

if kOpt==1
    K= cov(full(X'));
else
    K= cov(full(D)); % Alternative GP kernel (slower)
end

A=[];
NA=[1:size(D,2)]';
maxIM_set=[];

% eta = 0.0001; % a small value
% K(find(abs(K)<eta))=0; % truncation for fast computation
K(find(abs(K)<mean(mean(abs(K)))))=0;

if N_dict==N
    Dcompr = D;
    Xcompr = X;
    return;
end

ttt=cputime;
for iter=1:N
    maxIM = -inf;
    for i=1:size(D,2)
        if ismember(i, A)
            continue;
        end
        
        if isempty(A)
            sigma1 = K(i,i);
            H1 =.5*log(2*pi*exp(1)*sigma1);
        else
            idx1 = find(K(i,A)~=0);
            sigma1=K(i,i) - K(i,A(idx1))*inv(K(A(idx1),A(idx1)))*K(A(idx1),i);
            if(abs(sigma1)<1e-6)
                H1=0;
            else
                H1 =.5*log(2*pi*exp(1)*sigma1);
            end
        end
        
        if isempty(NA)
            sigma2 = K(i,i);
            H2=.5*log(2*pi*exp(1)*sigma2);
        else
            NA(find(NA==i))=[];
            
            idx2 = find(K(i,NA)~=0);
            sigma2=K(i,i) - K(i,NA(idx2))*inv(K(NA(idx2),NA(idx2)))*K(NA(idx2),i);
            if(abs(sigma2)<1e-6)
                H2=0;
            else
                H2=.5*log(2*pi*exp(1)*sigma2);
            end
        end
        
        IM=H1;
        NA=[NA;i];
        
        if IM > maxIM
            maxIM = IM;
            s = i;
        end
    end
    A=[A; s];
    maxIM_set=[maxIM_set;maxIM];
    
    NA(find(NA==s))=[];
end

Dcompr=D(:,A);

ctime = cputime-ttt;
fprintf(1,'(ME) Dictionary compressed from %d to %d in %f sec\n',N_dict, N, ctime);
