% Sam Q. Qiu (qiu@cs.umd.edu)
% Feb. 2011
%
% Reference:
%  Qiang Qiu, Zhuolin Jiang, and Rama Chellappa, "Sparse Dictionary-based 
%  Representation and Recognition of Human Action Attributes", International 
%  Conference on Computer Vision (ICCV) 2011


% Demo a general representative yet diverse sampling method
% Example, select samples to summarize a gesture sequence

clear all; 
close all;
warning off;
addpath(genpath('.\dfr')); % k-svd

rand('seed', 1)

load('gesture.mat', 'gesture'); % an example gesture sequence
Y = gesture;
Y = Y./repmat(sqrt(sum(Y.^2,1)), size(Y,1), 1);


% plot the action sequence (every 3rd frames)
figure;
for i=1:3:241
    subplot(9,9,(i-1)/3+1),
    yy = Y(:,i);
    yy = reshape(yy,16,16);
    imshow(yy,[]),
    set(gcf,'Color','w');
    pause(0.01);
end


T = 6; % spasity value
N = 16; % number of sample to select

% signal sampling using MMI (near optimal in both coverage and diversity)
Y_mmi = dict_compr_mmi(Y, Y, N, T, 2);

% signal sampling using ME (good diversity, poor coverage)
Y_me = dict_compr_me(Y, Y, N, T, 2);

% Plot select atoms selected. One method per row.
plotStackIm([Y_mmi; Y_me], 16, 16);

