% Sam Q. Qiu (qiu@cs.umd.edu)
% Feb. 2011
%
% Reference:
%  Qiang Qiu, Zhuolin Jiang, and Rama Chellappa, "Sparse Dictionary-based 
%  Representation and Recognition of Human Action Attributes", International 
%  Conference on Computer Vision (ICCV) 2011


% Demo dictionary atom selection using various methods

clear all;
close all;
addpath(genpath('.\dfr')); % k-svd

rand('seed', 1)

load('usps_data.mat', 'UspsData', 'LabelArr'); % usps digit dataset
Y = double(UspsData)'; % 16x16 image per column
C = LabelArr';
idx = find(C==10 | C==1 | C==2 |C==3); % pick digit 0, 1, 2, 3 as examples
Y=Y(:,idx);
C=C(idx);

dict_size = 64; % initial dictionary size
T = 6; % spasity value
N = 16; % number of atoms to select
IMG_H = 16;
IMG_W = 16;

[D, X] = trainKSVD(Y, T, dict_size, 50); % train init dict

% plot the initial dictionary
figure;
for i=1:64
    subplot(8,8,i),
    dd = D(:,i);
    dd = reshape(dd,16,16);
    imshow(dd,[]),
    set(gcf,'Color','w');
    pause(0.01);
end

% Dictionary atom selection using MMI
D_mmi = dict_compr_mmi(D, Y, N, T, 1);

% Dictionary atom selection using MMI2
lambda = dict_compr_mmi2_est(D, Y, C, N, T, 1);
D_mmi2 = dict_compr_mmi2(D, Y, C, N, T, lambda, 1);

% Dictionary atom selection using Liu-Shah
D_ls = dict_compr_ls(D, Y, C, N, T);

% Dictionary atom selection using ME
D_me = dict_compr_me(D, Y, N, T, 1);

% Plot select atoms selected. One method per row.
plotStackIm([D_mmi; D_mmi2; D_ls; D_me], 16, 16);

