function [IDXpred, accuracy, IDXdist] = knnprobe(probe, plabel, gallery, glabel, k);

IDXtrue=[];
IDXpred=[];
IDXdist=[];

for probIdx = 1:length(plabel)
       
%     trainfeats = feats(1:trainN, :);
    probfeats = probe(probIdx, :);
    
    [knnidx, knndist] = kNearestNeighbors(gallery, probfeats, k);
    rresult = mode(glabel(knnidx));
    
    idx = find(glabel(knnidx)==rresult);
    dist = mean(knndist(idx));
    IDXdist = [IDXdist; dist];
    
    IDXtrue=[IDXtrue;  plabel(probIdx)];
    IDXpred=[IDXpred; rresult];
    
end

accuracy = sum(IDXtrue==IDXpred)/length(IDXpred);