% Qiang Qiu, Rama Chellappa, Compositional Dictionaries for Domain Adaptive Face Recognition, 
% http://arxiv.org/abs/1308.0271
%
% Qiang Qiu, qiu@cs.umd.edu

function [Y6] = gen6form(Y, dim, nPerson, nLight, nPose)

Y6 = cell(6,1);

Y6{1} = Y;

% peform vector transpose
[Yt] = vt(Y, dim*nLight);
Y6{2} = Yt;

% Creat Y2: P x I
Y2=[];
for j=1:size(Y, 1)/(dim*nLight)
    yy = Y((j-1)*dim*nLight+1:j*dim*nLight, :);
    yy = vt(yy, dim);
    Y2=[Y2; yy];
end
Y6{3} = Y2;

Yt2 = vt(Y2, dim*nPerson);
Y6{4} = Yt2;

% Creat Y3: S x I
Y3=[];
for j=1:size(Yt, 1)/(dim*nLight)
    yy = Yt((j-1)*dim*nLight+1:j*dim*nLight, :);
    yy = vt(yy, dim);
    Y3=[Y3; yy];
end
Y6{5} = Y3;

Yt3 = vt(Y3, dim*nPose);
Y6{6} = Yt3;
