% Qiang Qiu, Rama Chellappa, Compositional Dictionaries for Domain Adaptive Face Recognition, 
% http://arxiv.org/abs/1308.0271
%
% Qiang Qiu, qiu@cs.umd.edu

function [yy] = da_trans(DD, a, b, c, dictsizeA, dictsizeC, dim);
% a: pose, b: subject, c: illumination
% trans subj a to new domains (a, c)

[Dc] = vt2(DD, dim, dictsizeC);
% plotStackIm(Dc(1:2*nPose*dim,1:9), dim, IMG_H2, IMG_W2);
Dc = Dc*c;
[Da] = vt2(Dc, dim, dictsizeA);
Da = Da*a;
Db = vt(Da, dim);
Db = normcol(Db);
yy = Db*b;