% Qiang Qiu, Rama Chellappa, Compositional Dictionaries for Domain Adaptive Face Recognition, 
% http://arxiv.org/abs/1308.0271
%
% Qiang Qiu, qiu@cs.umd.edu

function [a, b, c, yy] = da_omp3(y1, DD, dim, ompIter, dictsizeA, dictsizeB, dictsizeC, TdataA, TdataB, TdataC )


a = rand(dictsizeA,1);
c = rand(dictsizeC,1);

% Iterative omp
for i=1:ompIter % iteration
    % Generate b from (a,c)
    [Dc] = vt2(DD, dim, dictsizeC);
    Dc = Dc*c;
    [Da] = vt2(Dc, dim, dictsizeA);
    Da = Da*a;
    Db = vt(Da, dim);
    Db = normcol(Db);
    b = omp(Db'*y1,Db'*Db,TdataB); % subj
    
    % Generate c from (a,b)
    Da = DD*a;
    Db = vt(Da, dim*dictsizeC);
    Db = Db*b;
    Dc = vt(Db, dim);
    Dc = normcol(Dc);
    c = omp(Dc'*y1,Dc'*Dc,TdataC); % light
    
    % Generate a from (c,b)
    [Dc] = vt2(DD, dim, dictsizeC);
    Dc = Dc*c;
    Db=[];
    for j=1:size(Dc, 1)/(dim*dictsizeA)
        dd = Dc((j-1)*dim*dictsizeA+1:j*dim*dictsizeA, :);
        dd = reshape(dd, size(dd,1)*size(dd,2),1);
        Db=[Db dd];
    end
    Db = Db*b;
    Da = vt(Db, dim);
    Da = normcol(Da);
    a = omp(Da'*y1,Da'*Da,TdataA); % light
end

[Dc] = vt2(DD, dim, dictsizeC);
Dc = Dc*c;
[Da] = vt2(Dc, dim, dictsizeA);
Da = Da*a;
Db = vt(Da, dim);
Db = normcol(Db);
yy = Db*b;
% plotStackIm(yy, dim, IMG_H2, IMG_W2);