% Qiang Qiu, Rama Chellappa, Compositional Dictionaries for Domain Adaptive Face Recognition, 
% http://arxiv.org/abs/1308.0271
%
% Qiang Qiu, qiu@cs.umd.edu

function [DD, A, B, C] = da_dl(Y6, dicIter, dim, dictsizeA, dictsizeB, dictsizeC, TdataA, TdataB, TdataC, nPose, nPerson, nLight)


ksvdIter = 30;

[D, B] = trainKSVD(Y6{1}, TdataB, dictsizeB, ksvdIter);

for i=1:dicIter% iteration
    disp(['iter: ' num2str(i)]);
    % A vs B
    Yti = vt(Y6{1}*pinv(full(B)), dim*nLight);
    [Dt1, A] = trainKSVD(Yti, TdataA, dictsizeA, ksvdIter);
    Yi = vt(Y6{2}*pinv(full(A)), dim*nLight);
    [D1, B] = trainKSVD(Yi, TdataB, dictsizeB, ksvdIter);
    
    % A vs C
    Yi = vt(Y6{4}*pinv(full(A)), dim*nPerson);
    [D2, C] = trainKSVD(Yi, TdataC, dictsizeC, ksvdIter);
    Yti = vt(Y6{3}*pinv(full(C)), dim*nPerson);
    [Dt2, A] = trainKSVD(Yti, TdataA, dictsizeA, ksvdIter);
    
    % B vs C
    Yti = vt(Y6{5}*pinv(full(C)), dim*nPose);
    [Dt3, B] = trainKSVD(Yti, TdataB, dictsizeB, ksvdIter);
    Yi = vt(Y6{6}*pinv(full(B)), dim*nPose);
    [D3, C] = trainKSVD(Yi, TdataC, dictsizeC, ksvdIter);
end

%% Obtain Common Dictionary DD from D3
[Da] = vt2(D3, dim, nPose);
DD = Da*pinv(full(A)); % Common Dictionary
