/**
 * File name : segmentation.h
 *
 * File Description : This is a external header file for segmentation.c
 *
 * Author : Eri Haneda (haneda@purdue.edu), Purdue University
 * Created Date :
 * Version : 1.00
 *
 */

#ifndef _SEGMENTATION_H_
#define _SEGMENTATION_H_

#define MULTI_LAYER_RATE 2

/***************************************************/
/*  External structure Definition                  */
/***************************************************/
typedef struct {	
  double **lambda;
  unsigned int height; /* image height */
  unsigned int width;  /* image width */
  unsigned int min_block;  /* minimum block size */
  unsigned int max_block;  /* maximum block size */
  unsigned int dynamic_itr_num; /* vertical dynamic programming 
                                   iteration */
  unsigned int multi_lyr_itr;   /* multi-layer iteration */ 
  char calib_flg;               /* calibration flag */
  char* calib_filename;         /* segmentation file name */
  char CCC_skip_flg;            /* CCC skip flag */
  double text_cost;             /* Weights for text for the final layer */

  /* Temporary storage for multi-layer segmentation */ 
  unsigned char **S_b;      /* class of current layer */
  unsigned char **binmsk;   /* binary mask of current layer */
  unsigned char **prev_S_b; /* class of previous coarser layer */
  unsigned char **prev_binmsk; /* binary mask of previous layer */
  unsigned int cur_block;   /* current block size for multi-layer seg */
  unsigned int prev_nh;
  unsigned int prev_nw;
  unsigned int cur_nh;
  unsigned int cur_nw;
  unsigned int cur_lyr_itr;
} Seg_parameter;

/***************************************************/
/*  External function declarations                 */
/***************************************************/
int segmentation(TIFF_img *input_img, unsigned char **bin_msk, Seg_parameter *seg_para);

#endif
