/********************************************************************************************
  Filename: test_TIFF_RW.c
  Author  : Du-Yong Ng on 7/18/04
  Email   : dng@purdue.edu
  Comment :
  			This short program is written to demonstrate the use of the TIFF I/O subroutines
  			in TIFF_RW.c. This program copies an input image to an output image.
  			
  argv[1]: input.tif
  argv[2]: output.tif
  
  *******************************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "TIFF_RW.h"

/* This file pointer can be either the standard output, stderr or any file 
   The error messages can be redirected to a file without using a script.
   see EXAMPLE*/
FILE *file_stderr;


int main(int argc, char **argv)
{
  int i,j,k;	
  /* output file path */
  char output_filename_buf[150]="../img/output/";
  boolean error_flag = FALSE, image_supported = TRUE;
  TIFF_img *output_img=NULL, *input_img=NULL;
  
  /********************************************EXAMPLE begins *********************************************/
  /* option 1 */
  file_stderr = stderr; /* to direct errors to the standard output */
  
  /* option 2 */
  /* To record error messages in a file, for instance:
  FILE *record;
  if (( record = fopen("record.txt","w")) == NULL)
  	{
	  printf("Error opening file for writing.\n");
	  exit(-1);	
  	}
  file_stderr = record;
  ..... other data processing
  ..... the user can also record other outputs in the same file 
  fclose(record);
  /*********************************************EXAMPLE ends **********************************************/
	
  (void)strcat(output_filename_buf,argv[2]);
  
  input_img = Read_TIFF_File (argv[1], &error_flag);
  /* Check for reading error. If error occurs, free all the allocated memory before terminating the program. */
  if (error_flag)
		{
			printf("error opening file\n");
		if (input_img != NULL)
			free_TIFF_img(input_img);
		fprintf(file_stderr,"Failed to open input file\n");
		exit(-1);		
		}
  /* Create and initialized a new image buffer. Look at Create_New_img subroutine to modify tags of interest */
  output_img =Create_New_img(input_img->width,input_img->height, input_img->samplesperpixel, input_img->bitspersample, input_img->photometric, &error_flag);
  /* Check for error. If error occurs, free all the allocated memory before terminating the program. */
  if (error_flag == TRUE)
  {
	printf("Error opening file\n");
	if (output_img != NULL)
		free_TIFF_img(output_img);
	printf("output_img freed\n");
	exit(-1);	
  }
  /* Modify the initial tags as desired */
  output_img->compress = COMPRESSION_LZW;
  output_img->predictor = 1;
 
  /*output_img->compress = COMPRESSION_CCITTFAX3;
  output_img->compress_option = GROUP3OPT_2DENCODING;*/
  output_img->rowsperstrip = input_img->rowsperstrip;
  output_img->ResolutionUnit = input_img->ResolutionUnit;
  output_img->planarConfig = input_img->planarConfig;
  output_img->XResolution = input_img->XResolution;
  output_img->YResolution = input_img->YResolution;
  /* copy the input data */
  if (input_img->samplesperpixel == 1 && (input_img->bitspersample==1 || input_img->bitspersample ==8))
  {
	  for (i=0; i< input_img->height; i++)
		for (j=0; j<input_img->width;j++)
			output_img->mono[i][j] = input_img->mono[i][j];
		
  }
  else if (input_img->samplesperpixel == 3 && input_img->bitspersample == 8)
  {
	for (i=0; i< input_img->height; i++)
	  for (j=0; j<input_img->width;j++)
		for (k=0; k <3; k++)
		    output_img->color[k][i][j] = input_img->color[k][i][j];
  }
  else
	{
		printf("Only 1-bit, 8-bit and 24-bit images are supported\n");
		image_supported = FALSE;
	}

  if (image_supported)
  {
	  if(!Write_TIFF_File(output_img, output_filename_buf))
	    	fprintf(file_stderr,"Failed to write Test_write.tif\n");
  }

  /*free image buffers completely */
  if (output_img != NULL)
    	free_TIFF_img(output_img);
  if (input_img != NULL)
    	free_TIFF_img(input_img);	

  return 0;
}
