#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "Htables.h"

#define SOI  0xFFD8   /* Start of image marker */
#define SOF0 0xFFC0   /* Start of frame marker */
#define SOS  0xFFDA   /* Start of scan segment */
#define DQT  0xFFDB   /* Define quantization table */
#define DHT  0xFFC4   /* Define Huffman table */
#define COM  0xFFFE   /* Comments */
#define EOI  0xFFD9   /* End of image */


/***************************************************/
/*  Function declarations                          */
/***************************************************/

extern void put_header(int h, int v, int quant[][8],FILE *fileout) ;
extern void put_tail(FILE * fileout) ;


void put_header(
  int width,        /* number of columns in image */
  int height,       /* number of rows in image */
  int quant[8][8],  /* 8x8 quantization matrix */
  FILE * fileout)
{
  static unsigned char DC_table[] = 
  {0xFF,0xC4,0x00,0x1F,0x00, 
   0x00,0x01,0x05,0x01,0x01,0x01,0x01,0x01,0x01,0x00, 
   0x00,0x00,0x00,0x00,0x00,0x00,                 /* length table */
   0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B /* list part */
   } ; 


  static unsigned char AC_table[] = 
  {0xFF,0xC4,0x00,0xB5,0x10,
   0x00,0x02,0x01,0x03,0x03,0x02,0x04,0x03,
   0x05,0x05,0x04,0x04,0x00,0x00,0x01,0x7D,
   0x01,0x02,0x03,0x00,0x04,0x11,0x05,0x12,
   0x21,0x31,0x41,0x06,0x13,0x51,0x61,0x07,
   0x22,0x71,0x14,0x32,0x81,0x91,0xA1,0x08,
   0x23,0x42,0xB1,0xC1,0x15,0x52,0xD1,0xF0,
   0x24,0x33,0x62,0x72,0x82,0x09,0x0A,0x16, 
   0x17,0x18,0x19,0x1A,0x25,0x26,0x27,0x28,
   0x29,0x2A,0x34,0x35,0x36,0x37,0x38,0x39,
   0x3A,0x43,0x44,0x45,0x46,0x47,0x48,0x49,
   0x4A,0x53,0x54,0x55,0x56,0x57,0x58,0x59,
   0x5A,0x63,0x64,0x65,0x66,0x67,0x68,0x69,
   0x6A,0x73,0x74,0x75,0x76,0x77,0x78,0x79,
   0x7A,0x83,0x84,0x85,0x86,0x87,0x88,0x89,
   0x8A,0x92,0x93,0x94,0x95,0x96,0x97,0x98,
   0x99,0x9A,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,
   0xA8,0xA9,0xAA,0xB2,0xB3,0xB4,0xB5,0xB6,
   0xB7,0xB8,0xB9,0xBA,0xC2,0xC3,0xC4,0xC5,
   0xC6,0xC7,0xC8,0xC9,0xCA,0xD2,0xD3,0xD4,
   0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xE1,0xE2,
   0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,
   0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,
   0xF9,0xFA} ;

  static unsigned char Comment[] =
  {0xFF,0xFE,0x00,0x44,0x20,
   0x45,0x64,0x75,0x63,0x61,0x74,0x69,0x6f,
   0x6e,0x61,0x6c,0x20,0x50,0x75,0x72,0x70,
   0x6f,0x73,0x65,0x20,0x4f,0x6e,0x6c,0x79,
   0x3b,0x0a,0x20,0x53,0x6f,0x66,0x74,0x77,
   0x61,0x72,0x65,0x20,0x63,0x6f,0x70,0x79,
   0x72,0x69,0x67,0x68,0x74,0x20,0x50,0x75,
   0x72,0x64,0x75,0x65,0x20,0x55,0x6e,0x69,
   0x76,0x65,0x72,0x73,0x69,0x74,0x79,0x2e,
   0x0a
  } ;
   unsigned int qt[64] = {0} ;
   unsigned long val ;
   int      i,j,idx,idi ;
   char     *p  ;

   /* compute number of characters in a long */
   idx = sizeof(long)/sizeof(char) ;
   idi = sizeof(int)/sizeof(char) ;

   /* Image start header */
   val = SOI ;
   p = (char*)&val ;
   p += idx - 2 ;
   fwrite(p,sizeof(char),2,fileout) ;

   /* Quant table header */
   val = DQT ;
   p = (char*)&val ;
   p += idx - 2 ;
   fwrite(p,sizeof(char),2,fileout) ;

   /* Lq_h,Lq_l,(Pq,Tq) */
   val = 0x008310 ;  
   p = (char*)&val ;
   p += idx - 3 ;
   fwrite(p,sizeof(char),3,fileout) ;

   /* Quant table content in zigzag order */
   for( i=0 ;i<8; i++ )
     for( j=0; j<8; j++ ){
       qt[(Zig[i][j])] = quant[i][j] ;
     }
   for( i=0 ; i<64; i++ ){
     p = (char *)&qt[i] ;
     p += idi - 2 ;
     fwrite(p,sizeof(char),2,fileout) ;
   }

   /* Comments */
   fwrite(Comment,sizeof(char),sizeof(Comment)/sizeof(Comment[0]),fileout) ; 

   /* Baseline Frame start marker */
   val = SOF0; 
   p = (char*)&val ;
   p += idx - 2 ;
   fwrite(p,sizeof(char),2,fileout) ;

   /*  Lf_h,Lf_l,P,Y_h,Y_l,X_h,X_l */

   /* Lf and P */
   val = 0x000b08 ; 
   p = (char*)&val ;
   p += idx - 3 ;
   fwrite(p,sizeof(char),3,fileout) ;

   /* Y */
   val = height ;
   p = (char*)&val ;
   p += idx - 2 ;
   fwrite(p,sizeof(char),2,fileout) ;

   /* X */
   val = width ;
   p = (char*)&val ;
   p += idx - 2 ;
   fwrite(p,sizeof(char),2,fileout) ;

   /* Nf, H1, V1, and Tq1 */
   val = 0x01014400 ; /* Nf,Ci,(Hi,Vi),Tqi */
   p = (char*)&val ;
   p += idx - 4 ;
   fwrite(p,sizeof(char),4,fileout) ;

   /* DHT for luminance DC value category */
   fwrite(DC_table,sizeof(char),sizeof(DC_table),fileout) ;

   /* DHT for luminance AC zero-run & value category */
   fwrite(AC_table,sizeof(char),sizeof(AC_table),fileout) ;

   /* Start scan segment */
   val = SOS ;
   p = (char*)&val ;
   p += idx - 2 ;
   fwrite(p,sizeof(char),2,fileout) ;

   /* Ls, Ns, Csj */
   val = 0x00080101 ; 
   p = (char*)&val ;
   p += idx - 4 ;
   fwrite(p,sizeof(char),4,fileout) ;

   /* (Tdj, Taj),Ss,Se,(Ah,Al) */
   val = 0x00003F00 ; 
   p = (char*)&val ;
   p += idx - 4 ;
   fwrite(p, sizeof(char),4,fileout) ;
}

void put_tail(FILE * fileout)
{
   unsigned long val =  EOI ;
   char * p ;
   int  idx ;

   idx = sizeof(long)/sizeof(char) ;
   p = (char*)&val ;
   p += idx - 2 ;
   fwrite(p,sizeof(char),2,fileout) ; 
}



