#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>


/* JPEG Standard Quantization Table */
static int Quant[8][8] = {
    {16, 11, 10, 16, 24, 40, 51, 61},
    {12, 12, 14, 19, 26, 58, 60, 55},
    {14, 13, 16, 24, 40, 57, 69, 56},
    {14, 17, 22, 29, 51, 87, 80, 62},
    {18, 22, 37, 56, 68,109,103, 77},
    {24, 35, 55, 64, 81,104,113, 92},
    {49, 64, 78, 87,103,121,120,101},
     {72, 92, 95, 98,112,100,103, 99}
    };


/* JPEG Zig Zag ordering */
static int Zig[8][8] = {
    { 0, 1, 5, 6,14,15,27,28},
    { 2, 4, 7,13,16,26,29,42},
    { 3, 8,12,17,25,30,41,43},
    { 9,11,18,24,31,40,44,53},
    {10,19,23,32,39,45,52,54},
    {20,22,33,38,46,51,55,60},
    {21,34,37,47,50,56,59,61},
    {35,36,48,49,57,58,62,63}
    } ;


/* This is a definition for a structure containing the */
/* Huffman table for the differential DC coefficients. */
static struct dcHuffman {
  /* The length of each Huffman code. */
  int size[12] ;
  /* An ASCI sequence corresponding to the binary Huffman code. */
  char * code[12] ;
} dcHuffman = {
    { 2,3,3,3,3,3,4,5,6,7,8,9 },
    {
     "00","010","011","100","101","110","1110","11110",
     "111110","1111110","11111110","111111110"
    }
  } ;


/* This is a definition for a structure containing the */
/* Huffman table for the AC coefficients.              */
static struct acHuffman
{ 
  /* The length of each Huffman code. */
  int size[16][16] ;
  /* An ASCI sequence corresponding to the binary Huffman code. */
  char *code[16][16] ;
} acHuffman =
  { /* % each field array dimension should be same  */
    /* % or use ';' separator at the end of each row */
   {
     {4, 2, 2, 3, 4, 5, 7, 8,10,16,16, 0, 0, 0, 0, 0},/* EOB,0/1 - 0/A */
     {0, 4, 5, 7, 9,11,16,16,16,16,16, 0, 0, 0, 0, 0},/* 1/1 - 1/A */
     {0, 5, 8,10,12,16,16,16,16,16,16, 0, 0, 0, 0, 0},/* 2/1 - 2/A */
     {0, 6, 9,12,16,16,16,16,16,16,16, 0, 0, 0, 0, 0},/* 3/1 - 3/A */
     {0, 6,10,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0},/* 4/1 - 4/A */
     {0, 7,11,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0},/* 5/1 - 5/A */
     {0, 7,12,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0},/* 6/1 - 6/A */
     {0, 8,12,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0},/* 7/1 - 7/A */
     {0, 9,15,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0},/* 8/1 - 8/A */
     {0, 9,16,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0},/* 9/1 - 9/A */
     {0, 9,16,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0},/* A/1 - A/A */
     {0,10,16,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0},/* B/1 - B/A */
     {0,10,16,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0},/* C/1 - C/A */
     {0,11,16,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0},/* D/1 - D/A */
     {0,16,16,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0},/* E/1 - E/A */
    {11,16,16,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0}/* ZRL,F/1 - F/A */
   },
   { /* 0/0 - 0/A */
    {"1010",           
    "00",             
    "01",             
    "100",            
    "1011",           
    "11010",          
    "1111000",        
    "11111000",       
    "1111110110",
    "1111111110000010",
    "1111111110000011","-","-","-","-","-"},
    /* 1/1 - 1/A */
    {"-",                
    "1100",             
    "11011",            
    "1111001",          
    "111110110",        
    "11111110110",      
    "1111111110000100", 
    "1111111110000101", 
    "1111111110000110", 
    "1111111110000111", 
    "1111111110001000","-","-","-","-","-"},
    /* 2/1 - 2/A */
    {"-",                
    "11100",            
    "11111001",         
    "1111110111",       
    "111111110100",     
    "1111111110001001", 
    "1111111110001010", 
    "1111111110001011", 
    "1111111110001100", 
    "1111111110001101", 
    "1111111110001110","-","-","-","-","-"},
    /* 3/1 - 3/A */
    {"-",                 
    "111010",           
    "111110111",        
    "111111110101",     
    "1111111110001111", 
    "1111111110010000", 
    "1111111110010001", 
    "1111111110010010", 
    "1111111110010011", 
    "1111111110010100", 
    "1111111110010101","-","-","-","-","-"},
    /* 4/1 - 4/A */
    {"-",                
    "111011",           
    "1111111000",       
    "1111111110010110", 
    "1111111110010111", 
    "1111111110011000", 
    "1111111110011001", 
    "1111111110011010", 
    "1111111110011011", 
    "1111111110011100", 
    "1111111110011101","-","-","-","-","-"},
    /* 5/1 - 5/A */
    {"-", 
    "1111010", 
    "11111110111", 
    "1111111110011110", 
    "1111111110011111", 
    "1111111110100000", 
    "1111111110100001", 
    "1111111110100010", 
    "1111111110100011", 
    "1111111110100100", 
    "1111111110100101","-","-","-","-","-"},
    /* 6/1 - 6/A */
    {"-",                
    "1111011",          
    "111111110110",     
    "1111111110100110", 
    "1111111110100111", 
    "1111111110101000", 
    "1111111110101001", 
    "1111111110101010", 
    "1111111110101011", 
    "1111111110101100", 
    "1111111110101101","-","-","-","-","-"},
    /* 7/1 - 7/A */
    {"-",                
    "11111010",         
    "111111110111",     
    "1111111110101110", 
    "1111111110101111", 
    "1111111110110000", 
    "1111111110110001", 
    "1111111110110010", 
    "1111111110110011", 
    "1111111110110100", 
    "1111111110110101","-","-","-","-","-"},
    /* 8/1 - 8/A */
    {"-",                
    "111111000",        
    "111111111000000",  
    "1111111110110110", 
    "1111111110110111", 
    "1111111110111000", 
    "1111111110111001", 
    "1111111110111010", 
    "1111111110111011", 
    "1111111110111100", 
    "1111111110111101","-","-","-","-","-"},
    /* 9/1 - 9/A */
    {"-",                
    "111111001",        
    "1111111110111110", 
    "1111111110111111", 
    "1111111111000000", 
    "1111111111000001", 
    "1111111111000010", 
    "1111111111000011", 
    "1111111111000100", 
    "1111111111000101", 
    "1111111111000110","-","-","-","-","-"},
    /* A/1 - A/A */
    {"-",                
    "111111010",        
    "1111111111000111", 
    "1111111111001000", 
    "1111111111001001", 
    "1111111111001010", 
    "1111111111001011", 
    "1111111111001100", 
    "1111111111001101", 
    "1111111111001110", 
    "1111111111001111","-","-","-","-","-"},
    /* B/1 - B/A */
    {"-",                
    "1111111001",       
    "1111111111010000", 
    "1111111111010001", 
    "1111111111010010", 
    "1111111111010011", 
    "1111111111010100", 
    "1111111111010101", 
    "1111111111010110", 
    "1111111111010111", 
    "1111111111011000","-","-","-","-","-"},
    /* C/1 - C/A */
    {"-",                
    "1111111010",       
    "1111111111011001", 
    "1111111111011010", 
    "1111111111011011", 
    "1111111111011100", 
    "1111111111011101", 
    "1111111111011110", 
    "1111111111011111", 
    "1111111111100000", 
    "1111111111100001","-","-","-","-","-"},
    /* D/1 - D/A */
    {"-",                
    "11111111000",      
    "1111111111100010", 
    "1111111111100011", 
    "1111111111100100", 
    "1111111111100101", 
    "1111111111100110", 
    "1111111111100111", 
    "1111111111101000", 
    "1111111111101001", 
    "1111111111101010","-","-","-","-","-"},
    /* E/1 - E/A */
    {"-",                
    "1111111111101011", 
    "1111111111101100", 
    "1111111111101101", 
    "1111111111101110", 
    "1111111111101111", 
    "1111111111110000", 
    "1111111111110001", 
    "1111111111110010", 
    "1111111111110011", 
    "1111111111110100","-","-","-","-","-"},
    /* F/0 - F/A */
    {"11111111001",
    "1111111111110101", 
    "1111111111110110", 
    "1111111111110111", 
    "1111111111111000", 
    "1111111111111001", 
    "1111111111111010", 
    "1111111111111011", 
    "1111111111111100", 
    "1111111111111101", 
     "1111111111111110","-","-","-","-","-"}
   }
  } ;
    
