% This matlab m-file demonstrates how optimization
% methods operate to find the maximum of a function.

clear

print_flag = 0;
width = 1.5;
xord = -width:.15:width;
yord = -width:.15:width;
[x,y] = meshgrid(xord,yord);

z = func(x,y);

hold off
surfl(x,y,z)
xlabel('x axis')
ylabel('yaxis')
if print_flag, print
else, input('Coninue?'), end

[px,py] = gradient(z,.2,.2);

xstart = 0.9*width;
ystart =-0.3*width;

N = 10;
mu = 0.02;
steep_ascent(x,y,z,px,py,N,xstart,ystart)
if print_flag, print
else, input('Coninue?'), end


N = 10;
mu = 0.02;
coord_ascent(x,y,z,px,py,N,xstart,ystart)
if print_flag, print
else, input('Coninue?'), end


N = 100;
mu = 0.02;
grad_ascent(x,y,z,px,py,N,mu,xstart,ystart)
if print_flag, print
else, input('Coninue?'), end


N = 100;
mu = 0.06;
grad_ascent(x,y,z,px,py,N,mu,xstart,ystart)
if print_flag, print
else, input('Coninue?'), end


N = 100;
mu = 0.18;
grad_ascent(x,y,z,px,py,N,mu,xstart,ystart)
if print_flag, print
else, input('Coninue?'), end





