%Example of up-samplings (interpolation) by 3

clear all
close all
printout = 0;

L = 3;
N = 20;

n = 1:N;
x = sin(2*pi*n/10);

y((n*L)) = x;

subplot(2,1,1)
stem(x)
title('Discrete time signal x(n)')

subplot(2,1,2)
stem(y)
title('x(n) up-sampled by 3')

if printout==2
  print 
else 
  if printout==1
    print -deps upsample.ps
  else
    pause
  end
end


[X,wx] = dtft(x,1000);
[Y,wy] = dtft(y,1000);

figure
subplot(3,1,1)
plot(wx,abs(X))
title('DTFT of x(n)')

subplot(3,1,2)
plot(wy,abs(Y))
title('DTFT of y(n)')

subplot(3,1,3)
H = L*(abs(wy)<(pi/L));
plot(wy,H)
title('Ideal interpolation filter response')

if printout==2
  print 
else 
  if printout==1
    print -deps upsample_freq.ps
  else
    pause
  end
end

NN = length(y);
nn = 1:NN;
h = sinc((nn-round(NN/2))/L);

figure
subplot(2,1,1)
stem(h)
title('Ideal interpolating filter h(n)')

[H,wh] = dtft(h,1000);

subplot(2,1,2)
plot(wh,abs(H))
title('DTFT of H(n)')

if printout==2
  print 
else 
  if printout==1
    print -deps freq_upsample_filt.ps
  else
    pause
  end
end



