% This Matlab script illustrates 4 different types of subsampling

clear all
close all
printout = 0;

imgname = 'img04';
output = 'imgout';

% Decimation by subsampling (8x)
[r,g,b] = tiffread('img04.tif');

r = rep(rep(rep(dec(dec(dec(r))))));
g = rep(rep(rep(dec(dec(dec(g))))));
b = rep(rep(rep(dec(dec(dec(b))))));

tiffwrite(r,g,b,sprintf('%s/%sd8.tif',output,imgname));




% Decimation by subsampling (4x)
[r,g,b] = tiffread('img04.tif');

r = rep(rep(dec(dec(r))));
g = rep(rep(dec(dec(g))));
b = rep(rep(dec(dec(b))));

tiffwrite(r,g,b,sprintf('%s/%sd4.tif',output,imgname));




% Decimation by block averaging
[r,g,b] = tiffread('img04.tif');

M=15;
MM = 2*M+1;
[m,n] = meshgrid(-M:M,-M:M);

h = (m>=0)&(m<4)&(n>=0)&(n<4);

mesh(h)
title('2-D Filter Impulse Response used for Block Averaging');

if printout==2
  print
else
  if printout==1
    print -deps BlockAveFilter.ps
  else
    pause
  end
end

h = ones(4,4)/16;

r = conv2(r,h,'same');
g = conv2(g,h,'same');
b = conv2(b,h,'same');

r = rep(rep(dec(dec(r))));
g = rep(rep(dec(dec(g))));
b = rep(rep(dec(dec(b))));

tiffwrite(r,g,b,sprintf('%s/%sd4ave.tif',output,imgname));




% Decimation using ideal sinc function
[r,g,b] = tiffread('img04.tif');

M=15;
MM = 2*M+1;
[m,n] = meshgrid(-M:M,-M:M);

h = (1/16)*sinc(m/4).*sinc(n/4).*(hamming(MM)*hamming(MM)');
mesh(h)
title('2-D Sinc Filter used for Ideal Subsampling');

if printout==2
  print
else
  if printout==1
    print -deps SincFilter.ps
  else
    pause
  end
end

r = min(1,max(0,conv2(r,h,'same')));
g = min(1,max(0,conv2(g,h,'same')));
b = min(1,max(0,conv2(b,h,'same')));

r = rep(rep(dec(dec(r))));
g = rep(rep(dec(dec(g))));
b = rep(rep(dec(dec(b))));

tiffwrite(r,g,b,sprintf('%s/%sd4sinc.tif',output,imgname));



