function plotsin(u0,v0,x,y)


[X,Y] = meshgrid(x,y);
N = length(x);
u = ((1:N) - (N/2) -1)/N;
v = u;

f = cos(2*pi*u0*X + 2*pi*v0*Y);

subplot(1,2,1)
imagesc(x,y,f)
axis('image')
colormap('gray')
S = sprintf('Cosine: U_0=%0.5g and V_0=%0.5g',u0,v0);
title(S);

F = fft2(f);
F = abs(fftshift(F));

subplot(1,2,2)
imagesc(u,v,F)
axis('image')
colormap('gray')
title('Frequency Response')
