

%Examples of 2-D transfer functions for IIR filters

% Set to value 1 if you want a printout
print_out = 0;


delta = 0.1;

j = sqrt(-1);

x = -pi:delta:pi;
y = -pi:delta:pi;


[omegax,omegay] = meshgrid( x,y );

a = 0.4;
H = (1 - a*exp(-j*omegax) - a*exp(-j*omegay) ).^(-1);

Habs = abs(H);

mesh(x,y,Habs);
title('Mesh Plot of MTF for (1 - 0.4*Z_1^-1 - 0.4*Z_2^-1)^-1') 
if print_out==1
  print
end

figure
contour(Habs);
title('Contour Plot of MTF for (1 - 0.4*Z_1^-1 - 0.4*Z_2^-1)^-1') 
if print_out==1
  print
end

a = 0.2;
H2 = (1 - a*exp(-j*omegax) - a*exp(-j*omegay) -2*a*exp(j*omegax).*exp(-j*omegay) ).^(-1);
%H2 = (1 - a*exp(j*omegax).*exp(-j*omegay) ).^(-1);

H2abs = abs(H2);

figure
mesh(10*x,y,H2abs);
title('Mesh Plot of MTF for (1 - 0.2*Z_1^-1 - 0.2*Z_2^-1 - 0.4*Z_1^-1*Z_2^-1  )^-1') 
if print_out==1
  print
end

figure
contour(H2abs);
title('Contour Plot of MTF for (1 - 0.2*Z_1^-1 - 0.2*Z_2^-1 - 0.4*Z_1^-1*Z_2^-1  )^-1') 
if print_out==1
  print
end

