
% Clear memory and close existing figures
clear
close

% This line reads in gray scale TIFF image. 
% The matrix img contains a 2-D array of color indices, and map
% is the corresponding colormap. So the pixel at location (i,j)
% has the color [r,g,b] = map(img(i,j),:) .

[img,map] = tiffread('img04g.tif');


% This line sets the colormap, displays the image, and sets the
% axises so that pixels are square.

colormap(map);
image(img)
axis('image')


% This built-in Matlab function computes the actual gray scale value
% for each pixel and stores the result in the matrix X.

X = ind2gray(img,map);


% Select an NxN region of the image and store it in the variable "z"

i=100;
j=100;

N = 64;
z = X(i:(N+i-1), j:(N+j-1));


% Compute the power spectrum for the NxN region
Z = (1/N^2)*abs(fft2(z)).^2;

% Use fftshift to move the zero frequencies to the center of the plot
Z = fftshift(Z);

% Compute the logarithm of the Power Spectrum.
Zabs = log( Z );


% Plot the result using a 3-D mesh plot and label the x and y axises properly. 

x = 2*pi*((0:(N-1)) - N/2)/N;
y = 2*pi*((0:(N-1)) - N/2)/N;
figure 
mesh(x,y,Zabs)




