
clear



% Decimation by subsampling (8x)
[r,g,b] = tiffread('img04.tif');

r = rep(rep(rep(dec(dec(dec(r))))));
g = rep(rep(rep(dec(dec(dec(g))))));
b = rep(rep(rep(dec(dec(dec(b))))));

tiffwrite(r,g,b,'img04d8.tif')




% Decimation by subsampling (4x)
[r,g,b] = tiffread('img04.tif');

r = rep(rep(dec(dec(r))));
g = rep(rep(dec(dec(g))));
b = rep(rep(dec(dec(b))));

tiffwrite(r,g,b,'img04d4.tif')




% Decimation by block averaging
[r,g,b] = tiffread('img04.tif');

h = ones(4,4)/16;

r = conv2(r,h,'same');
g = conv2(g,h,'same');
b = conv2(b,h,'same');

r = rep(rep(dec(dec(r))));
g = rep(rep(dec(dec(g))));
b = rep(rep(dec(dec(b))));

tiffwrite(r,g,b,'img04d4ave.tif')




% Decimation using ideal sinc function
[r,g,b] = tiffread('img04.tif');

M=15;
MM = 2*M+1;
[m,n] = meshgrid(-M:M,-M:M);

h = (1/16)*sinc(m/4).*sinc(n/4).*(hamming(MM)*hamming(MM)');
mesh(h)

r = min(1,max(0,conv2(r,h,'same')));
g = min(1,max(0,conv2(g,h,'same')));
b = min(1,max(0,conv2(b,h,'same')));

r = rep(rep(dec(dec(r))));
g = rep(rep(dec(dec(g))));
b = rep(rep(dec(dec(b))));

tiffwrite(r,g,b,'img04d4sinc.tif')
