% This matlab m-file generates marginal probability
% that a pixel X_s=1 for an Ising model. A series
% of functions for differing beta are plotted.

clear all
close all

set(0,'defaultaxesfontsize',20)

for i=1:6
  beta = 1.5*((i-1)/6);
  if beta<0 
    string(i,:) = sprintf('\\beta = %1.2f',beta);
  else
   string(i,:) = sprintf('\\beta =  %1.2f',beta);
  end

  n=0:4;
  prob(i,:) = 1./( 1+exp(2*beta*(n-2)) );
end

plot(n,prob,'Linewidth',3)
title('Probability that X_s = 1')
xlabel('Number of neighbors not equal to 1')
ylabel('Probability')
legend(string(1,:),string(2,:),string(3,:),string(4,:),string(5,:),string(6,:)); 
 
print -depsc IsingConDist.eps

