% This matlab m-file demonstrates how optimization
% methods operate to find the maximum of a function.

clear


print_flag = 1;
width = 1.5;
xord = -width:.05:width;
yord = -width:.05:width;
[x,y] = meshgrid(xord,yord);

z = func(x,y);

hold off
az = -20; el = 45;
surfl(x,y,z)
view(az,el)
xlabel('x axis')
ylabel('yaxis')
if print_flag, print -depsc output/Function1.eps
else, input('Coninue?'), end


hold off
az = 30; el = 45;
surfl(x,y,z)
view(az,el)
xlabel('x axis')
ylabel('yaxis')
if print_flag, print -depsc output/Function2.eps
else, input('Coninue?'), end



[px,py] = gradient(z,.2,.2);

xstart = 0.9*width;
ystart =-0.3*width;


N = 100;
mu = 0.02;
grad_ascent(x,y,z,px,py,N,mu,xstart,ystart)
if print_flag, print -depsc output/GradDescent-02.eps
else, input('Coninue?'), end


N = 100;
mu = 0.06;
grad_ascent(x,y,z,px,py,N,mu,xstart,ystart)
if print_flag, print -depsc output/GradDescent-06.eps
else, input('Coninue?'), end


N = 100;
mu = 0.18;
grad_ascent(x,y,z,px,py,N,mu,xstart,ystart)
if print_flag, print -depsc output/GradDescent-18.eps
else, input('Coninue?'), end


N = 10;
steep_ascent(x,y,z,px,py,N,xstart,ystart)
if print_flag, print -depsc output/SteepestDescent.eps
else, input('Coninue?'), end


N = 10;
coord_ascent(x,y,z,px,py,N,xstart,ystart)
if print_flag, print -depsc output/ICD.eps
else, input('Coninue?'), end




