% This matlab m-file generates some examples
% of continuously valued and discretely valued
% Markov chains.

clear all
close all

print_flag = 1;

set(0,'defaultaxesfontsize',20)

N=100;

x = randn(N,1);
y = cumsum(x);
plot(y)
axis([1 N -15 15]);
title('Continuous Valued Markov Chain: Sigma = 1')
xlabel('discrete time, n')
ylabel('yaxis')
if print_flag, print -depsc output/MCcase1.eps
else, input('Coninue?'), end


rho = 0.1;
x(1) = rand(1)<0.5;
for i=2:N
  change = rand(1)<rho;
  if(change) 
    x(i) = ~x(i-1);
  else 
    x(i) = x(i-1);
  end
end

plot(x)
axis([1 N -1 2]);
S = sprintf('Binary Valued Markov Chain: rho = %f',rho);
title(S)
xlabel('discrete time, n')
ylabel('yaxis')
if print_flag, print -depsc output/MCcase2.eps
else, input('Coninue?'), end


rho = 0.02;
x(1) = rand(1)<0.5;
for i=2:N
  change = rand(1)<rho;
  if(change)
    x(i) = ~x(i-1);
  else
    x(i) = x(i-1);
  end
end

plot(x)
axis([1 N -1 2]);
S = sprintf('Binary Valued Markov Chain: rho = %f',rho);
title(S)
xlabel('discrete time, n')
ylabel('yaxis')
if print_flag, print -depsc output/MCcase3.eps
else, input('Coninue?'), end


rho = 0.5;
x(1) = rand(1)<0.5;
for i=2:N
  change = rand(1)<rho;
  if(change)
    x(i) = ~x(i-1);
  else
    x(i) = x(i-1);
  end
end

plot(x)
axis([1 N -1 2]);
S = sprintf('Binary Valued Markov Chain: rho = %f',rho);
title(S)
xlabel('discrete time, n')
ylabel('yaxis')
if print_flag, print -depsc output/MCcase4.eps
else, input('Coninue?'), end



rho = 0.9;
x(1) = rand(1)<0.5;
for i=2:N
  change = rand(1)<rho;
  if(change)
    x(i) = ~x(i-1);
  else
    x(i) = x(i-1);
  end
end

plot(x)
axis([1 N -1 2]);
S = sprintf('Binary Valued Markov Chain: rho = %f',rho);
title(S)
xlabel('discrete time, n')
ylabel('yaxis')
if print_flag, print -depsc output/MCcase5.eps
else, input('Coninue?'), end






