clear

printflag=0;

delta = 0.2;
range = 10;

% Set repitition period
T = 3;

[x,y] = meshdom(-range:delta:range, -range:delta:range);


% Example 4
N = ceil(range/T);
z = 0*x;
for i=-N:N
for j=-N:N
  z = z + rect2(x-i*T,y-j*T);
end
end
wind = range;
z = z.*rect2(x/wind,y/wind);
showimage(z,'rep_{T,T} { rect(x,y)}*rect2(x/wind,y/wind)',printflag)

Z = DSFT(z);
showimage(Z,'CSFT{rep_{T,T} { rect(x,y)}*rect2(x/wind,y/wind)}',printflag)

