clear

printflag=0;

delta = 0.2;
range = 10;

% Set repitition period
T = 3;

[x,y] = meshdom(-range:delta:range, -range:delta:range);


% Example 3
N = ceil(range/T);
z = 0*x;
for i=-N:N
for j=-N:N
  z = z + rect2(x-i*T,y-j*T);
end
end
showimage(z,'rep_{T,T} { rect(x,y)}',printflag)

Z = DSFT(z);
showimage(Z,'CSFT{rep_{T,T} { rect(x,y)}}',printflag)

