%Generates patterns to demonstrate Moire
clear all
printflag =0;


N = 256;

% set sampling period
T=2; 

%Set colormap
map = [1:255; 1:255; 1:255]'/255;
colormap(map);

x = zeros(N);
y = x;

% Generate Comb sampling pattern
comb = zeros(N);
comb(1:T:N,1:T:N) = ones(N/T);
image(255*comb)
colormap(map)
axis('image')
title('2-D Sampling Pattern')
if printflag==1
  print
else
  pause
end


% Generate dot pattern
dp(1:2:N,1:2:N) = ones(N/2);
image(255*dp)
colormap(map)
axis('image')
title('Dot Pattern')
if printflag==1
  print
else
  pause
end


% Generate cosine plane waves
[x,y] = meshdom(1:N,1:N);

fx = 1.2*(1/(2*T)); %aliased 
fy = 0.8*(1/(2*T)); %not aliased 

wave1 = 0.5*cos(2*pi*fx*x + 2*pi*fy*y) + 0.5;
image(255*wave1)
colormap(map)
axis('image')
title('Plane wave')
if printflag==1
  print
else
  pause
end


% Generate sampled cosine plane waves

wavesamp = comb.*wave1;
image(255*wavesamp)
colormap(map)
axis('image')
title('Plane wave')
if printflag==1
  print
else
  pause
end

