% EE 438 Digital Signal Processing with Applications - Fall 1997
% Application of decimation/interpolation to speech
%---------------------------------------------------------------
% Initialize
clear all;
close all;

%Read data sampled at 12.5kHz
load Data1
N = length(x)
n = 1:1:N;
t = (n-1)./Fs;

% Set interpolation rate
D = 4

%---------------------------------------------------------------
% Upsampling by D
z = zeros(1,D.*N);
z(1:D:D.*N) = x(1:N);
x_extend = zeros(1,D.*N);
x_extend(1:N) = x;
n_extend = 1:1:(D*N);
t_extend = n_extend./Fs;

% Plot upsampled signal
figure(1);
subplot(2,1,1), plot(x_extend);
xlabel('n samples');
title('Original utterance');
subplot(2,1,2), plot(z);
xlabel('n samples');
title('Utterance upsampled by D');
pause

% Compute frequency transform
X_extend = fft(x_extend);
X_extend = fftshift(X_extend);
Xmag_extend = abs(X_extend);
Z = fft(z);
Z = fftshift(Z);
Zmag = abs(Z);
delta_f = Fs./(D.*N.*1000);
nf = -(D*N/2):1:(D*N/2 -1);
f = nf .* delta_f;
omega = nf .* (2*pi/N);

% Plot frequency transforms
figure(2);
subplot(2,1,1), plot(omega,Xmag_extend);
xlabel('Omega in radians');
title('Original utterance');
subplot(2,1,2), plot(omega,Zmag);
xlabel('Omega in radians');
title('Utterance upsampled by D');

% Play back signals
input('Play original utterance')
sound(x,Fs);
input('Play utterance upsampled by D')
sound(z,Fs);
input('Play utterance upsampled by D, at rate Fs*4')
sound(z,4*Fs);
