% EE 438 Digital Signal Processing with Applications - Fall 1997
% Application of decimation to speech
%---------------------------------------------------------------
% Initialize
clear all;
close all;

%Read data sampled at 12.5kHz
load Data1
N = length(x)
n = 1:1:N;
t = (n-1)./Fs;

% Set decimation rate
D = 4

%---------------------------------------------------------------
% Downsampling by D
z = zeros(1,N);
z(1:ceil(N/D)) = x(1:D:N);

% Plot downsampled signal
figure(1);
subplot(2,1,1), plot(x);
xlabel('n samples');
title('Original utterance');
subplot(2,1,2), plot(z);
xlabel('n samples');
title('Utterance downsampled by D');
pause

% Compute spectrum of signals
X = fft(x);
X = fftshift(X);
Xmag = abs(X);
Z = fft(z);
Z = fftshift(Z);
Zmag = abs(Z);
delta_f = Fs./(N.*1000);
nf = -N./2:1:(N/2-1);
f = nf .* delta_f;
omega = nf .* (2*pi/N);

% Plot spectrum of signal
figure(2);
subplot(2,1,1), plot(omega,Xmag);
xlabel('Omega in radians');
title('Original utterance');
subplot(2,1,2), plot(omega,Zmag);
xlabel('Omega in radians');
title('Utterance downsampled by D');

% Play back signals
input('Play original utterance')
sound(x,Fs);
input('Play utterance downsampled by D')
sound(z,Fs);
input('Play utterance downsampled by D, played at Fs/D')
sound(z,Fs./D);
