% EE 438 Digital Signal Processing with Applications - Fall 1997
% Application of elementary signal operations to speech signal
%---------------------------------------------------------------

% Initialize and load audio data
clear all;
load Data1
N = length(x)

%---------------------------------------------------------------
%Create reverberation by adding shifted version of signal
delay = 0.4
atten = 0.5
n0 = round(delay.*Fs)
n_ext = 1:1:N+n0;
x_delay(1+n0:N+n0) = x(n_ext(1+n0:N+n0)-n0);
x_extend = x;
x_extend(N+1:N+n0) = zeros(1,n0);
y = x_extend + atten.*x_delay;
t_extend = (n_ext-1)./Fs;
subplot(2,1,1), plot(t_extend,x_extend);
xlabel('t sec');
title('Original utterance');
subplot(2,1,2), plot(t_extend,y);
xlabel('t sec');
title('Utterance with reverberation');
input('Original utterance')
sound(x,Fs);
input('Utterance with reverberation')
sound(y,Fs);

%---------------------------------------------------------------
% Reflection
n = 1:1:N;
minus_n = N+1 - n;
z = x(minus_n);
t = (n-1)./Fs;
subplot(2,1,1), plot(t, x);
xlabel('t sec');
title('Original utterance');
subplot(2,1,2), plot(t, z);
xlabel('t sec');
title('Reflected utterance');
input('Original utterance')
sound(x,Fs);
input('Reflected utterance')
sound(z,Fs);

%---------------------------------------------------------------
% Downsampling by 2
z = zeros(1,N);
z(1:ceil(N/2)) = x(1:2:N);
z(ceil(N/2)+1:N) = zeros(1,N-ceil(N/2));
subplot(2,1,1), plot(t,x);
xlabel('t sec');
title('Original utterance');
subplot(2,1,2), plot(t,z);
xlabel('t sec');
title('Utterance downsampled by 2');
input('Original utterance')
sound(x,Fs);
input('Utterance downsampled by 2')
sound(z,Fs);

%---------------------------------------------------------------
% Upsampling by 2
z = zeros(1,2.*N);
z(1:2:2.*N) = x(1:N);
x_extend(N+1:2.*N) = zeros(1,N);
n_extend = 1:1:2.*N;
t_extend = n_extend./Fs;
subplot(2,1,1), plot(t_extend,x_extend);
xlabel('t sec');
title('Original utterance');
subplot(2,1,2), plot(t_extend,z);
xlabel('t sec');
title('Utterance upsampled by 2');
input('Original utterance')
sound(x,Fs);
input('Utterance upsampled by 2')
sound(z,Fs);

