%--------------------------------------------------------------
% Initialize
%
close all;
clear all;
%--------------------------------------------------------------
% Generate signal
%
x = sig_2_gen;
N = length(x);
%--------------------------------------------------------------
% Put it through the system
%
y = system_2(x);
%--------------------------------------------------------------
% Generate plots
%
figure(1)
subplot(2, 1, 1), stem(x)
title('System input')
xlabel('n')
ylabel('x[n]')
subplot(2, 1, 2), stem(y)
title('System output')
xlabel('n')
ylabel('y[n]')
pause
%--------------------------------------------------------------
% Compute spectra
%
M = 256
X = dtft(x, M);
Y = dtft(y, M);
%--------------------------------------------------------------
% Plot spectra
%
omega = -pi:2*pi/(M-1):pi;
figure(2)
subplot(2, 1, 1), plot(omega, abs(Y))
title('Output spectrum magnitude')
ylabel('|Y(omega)|')
axis([-pi, pi, 0, max(abs(Y))])
subplot(2, 1, 2), plot(omega, abs(X))
title('Input spectrum magnitude')
ylabel('|X(omega)|')
axis([-pi, pi, 0, max(abs(X))])
%--------------------------------------------------------------
