%--------------------------------------------------------------
% Initialize
%
close all;
clear all;
%--------------------------------------------------------------
% Generate signal
%
x = sig_1_gen;
N = length(x);
%--------------------------------------------------------------
% Put it through the system
%
y = system_1(x);
%--------------------------------------------------------------
% Generate plots
%
figure(1)
subplot(2, 1, 1), stem(x)
title('System input')
xlabel('n')
ylabel('x[n]')
subplot(2, 1, 2), stem(y)
title('System output')
xlabel('n')
ylabel('y[n]')
pause
%--------------------------------------------------------------
% Compute spectra and transfer functions
%
M = 128
X = dtft(x, M);
Y = dtft(y, M);
H_1 = Y./X;
%--------------------------------------------------------------
% Plot spectra and transfer functions
%
omega = -pi:2*pi/(M-1):pi;
figure(2)
subplot(3, 1, 1), plot(omega, abs(Y))
title('Output spectrum magnitude')
ylabel('|Y(omega)|')
axis([-pi, pi, 0, max(abs(Y))])
subplot(3, 1, 2), plot(omega, abs(X))
title('Input spectrum magnitude')
ylabel('|X(omega)|')
axis([-pi, pi, 0, max(abs(X))])
subplot(3, 1, 3), plot(omega, abs(H_1))
title('Transfer function No. 1 magnitude')
xlabel('omega')
ylabel('|H_1(omega)|')
axis([-pi, pi, 0, max(abs(H_1))])
pause
%--------------------------------------------------------------
% Put the signal through the system again
%
z = system_1(y);
%--------------------------------------------------------------
% Generate plots
%
figure(3)
subplot(2, 1, 1), stem(y)
title('System input')
xlabel('n')
ylabel('y[n]')
subplot(2, 1, 2), stem(z)
title('System output')
xlabel('n')
ylabel('z[n]')
pause
%--------------------------------------------------------------
% Compute spectra and transfer functions
%
M = 128
Y = dtft(y, M);
Z = dtft(z, M);
H_2 = Z./Y;
%--------------------------------------------------------------
% Plot spectra and transfer functions
%
figure(4)
subplot(3, 1, 1), plot(omega, abs(Z))
title('Output spectrum')
ylabel('Z(omega)')
axis([-pi, pi, 0, max(abs(Z))])
subplot(3, 1, 2), plot(omega, abs(Y))
title('Input spectrum')
ylabel('Y(omega)')
axis([-pi, pi, 0, max(abs(Y))])
subplot(3, 1, 3), plot(omega, abs(H_2))
title('Transfer function No. 2')
xlabel('omega')
ylabel('H_2(omega)')
axis([-pi, pi, 0, max(abs(H_1))])
pause
figure(5)
subplot(2, 1, 1), plot(omega, abs(H_1))
title('Transfer function No. 1')
xlabel('omega')
ylabel('H_1(omega)')
axis([-pi, pi, 0, max(abs(H_1))])
subplot(2, 1, 2), plot(omega, abs(H_2))
title('Transfer function No. 2')
xlabel('omega')
ylabel('H_2(omega)')
axis([-pi, pi, 0, max(abs(H_1))])
%--------------------------------------------------------------

