% EE 438 Digital Signal Processing with Applications - Spring 1997
% Implementation of elementary signal operations in Matlab
% Note that there are NO for loops in any of these examples
%---------------------------------------------------------------
% Initialize
clear all;
close all;
%---------------------------------------------------------------
% Generate "widget"
n = 1:1:8;
x(1:4) = (n(1:4)-1)./4;
x(5:8) = ones(1,4);
figure(1);
subplot(2,1,1), stem(n-1,x)
xlabel('n')
ylabel('x')
title('Original widget')
pause
%---------------------------------------------------------------
% Shifting
y(2:8) = x(n(2:8)-1)	%Note that we skip 1st element
subplot(2,1,2), stem(n-1,y)
xlabel('n')
ylabel('y')
title('Shifting to right by 1')
pause
%---------------------------------------------------------------
% Reflection
n
minus_n = 9-n
y = x(minus_n);
subplot(2,1,2), stem(n-1,y)
xlabel('n')
ylabel('y')
title('Reflection')
pause
%---------------------------------------------------------------
% Scaling - downsampling
%By analogy to y(t) = x(2t)
y = zeros(1,8);
y(1:4) = x(2*(n(1:4)-1)+1);
subplot(2,1,2), stem(n-1,y)
xlabel('n')
ylabel('y')
title('Downsampling by 2')
pause
%---------------------------------------------------------------
% Scaling - downsampling
% A more straightforward approach
y = zeros(1,8);
y(1:4) = x(1:2:8);
subplot(2,1,2), stem(n-1,y)
xlabel('n')
ylabel('y')
title('Downsampling by 2 - better way')
pause
%---------------------------------------------------------------
%Scaling - upsampling
%y(n) = x(n/2) will not work
y = zeros(1,8);
y(1:2:8) = x(1:4);
subplot(2,1,2), stem(n-1,y)
xlabel('n')
ylabel('y')
title('Upsampling by 2')
pause
