% EE 438 Digital Signal Processing with Applications - Spring 1997
% Application of elementary signal operations to speech signal
%---------------------------------------------------------------
% Initialize
clear all;
close all;
%Read and play back data sampled at 12.5kHz
Fs = 12500;
fp=fopen('erf1s1t0','r');
[data,M]=fread(fp,[1,1024],'char');
[data,N]=fread(fp,[1,inf],'short');
fclose(fp);
plot(data)
%end1=input('end1?');
%end2=input('end2?');
end1 = 3000;
end2 = end1+8191;
x=data(end1:end2);
N = length(x)
D = 4
%---------------------------------------------------------------
% Downsampling by D
n = 1:1:N;
t = (n-1)./Fs;
z = zeros(1,N);
z(1:ceil(N/D)) = x(1:D:N);
z(ceil(N/D)+1:N) = zeros(1,N-ceil(N/D));

figure(1);
subplot(2,1,1), plot(t,x);
xlabel('t sec');
title('Original utterance');
subplot(2,1,2), plot(t,z);
xlabel('t sec');
title('Utterance downsampled by D');

X = fft(x);
X = fftshift(X);
Xmag = abs(X);
Z = fft(z);
Z = fftshift(Z);
Zmag = abs(Z);
delta_f = Fs./(N.*1000);
nf = -N./2:1:N/2-1;
f = nf .* delta_f;

figure(2);
subplot(2,1,1), plot(f,Xmag);
xlabel('f kHz');
title('Original utterance');
subplot(2,1,2), plot(f,Zmag);
xlabel('f kHz');
title('Utterance downsampled by D');

input('Original utterance')
sound(x,Fs);
input('Utterance downsampled by D')
sound(z,Fs);
input('Utterance downsampled by D, played at Fs/D')
sound(z,Fs./D);
%---------------------------------------------------------------
% Upsampling by D
z = zeros(1,D.*N);
z(1:D:D.*N) = x(1:N);
x_extend = x;
x_extend(N+1:D.*N) = zeros(1,(D-1).*N);
n_extend = 1:1:D.*N;
t_extend = n_extend./Fs;

figure(1);
subplot(2,1,1), plot(t_extend,x_extend);
xlabel('t sec');
title('Original utterance');
subplot(2,1,2), plot(t_extend,z);
xlabel('t sec');
title('Utterance upsampled by D');

X_extend = fft(x_extend);
X_extend = fftshift(X_extend);
Xmag_extend = abs(X_extend);
Z = fft(z);
Z = fftshift(Z);
Zmag = abs(Z);
delta_f = Fs./(D.*N.*1000);
nf = -D.*N./2:1:D.*N/2-1;
f = nf .* delta_f;

figure(2);
subplot(2,1,1), plot(f,Xmag_extend);
xlabel('f kHz');
title('Original utterance');
subplot(2,1,2), plot(f,Zmag);
xlabel('f kHz');
title('Utterance upsampled by D');

input('Original utterance')
sound(x,Fs);
input('Utterance upsampled by D')
sound(z,Fs);
