clear all
N = 200
M = 4
lag(1) = 0;
lag(2) = 1;
lag(3) = 2;
lag(4) = 4;
n = 1:1:N;
m = 1:1:2*M-1;
h_0 = 0.5*(1+ cos(2*pi*(m-M)/(2*M)));
h = h_0/sum(h_0);
x = randn(1,N);
y_00 = conv(h,x);
y(1:N) = y_00(1:N);

figure(1);
subplot(3,1,1), stem(m-1,h);
title('Filter');
xlabel('n');
ylabel('h[n]');
subplot(3,1,2), plot(n,x);
title('Input');
xlabel('n');
ylabel('x[n]');
subplot(3,1,3), plot(n,y);
title('Output');
xlabel('n');
ylabel('y[n] = h[n]*x[n]');

figure(2);
x_0(1:N-1) = x(1:N-1);
x_1(1:N-1) = x(2:N);
plot(x_0, x_1, '.');
title('Scatter plot for x[n] vs. x[n+1]')
xlabel('x[n]');
ylabel('x[n+1]');

figure(3);
for p = 1:4
    clear y_0; clear y_1;
	el = lag(p);
	y_0(1:N-el) = y(1:N-el);
	y_1(1:N-el) = y(1+el:N);
	subplot(2,2,p), plot(y_0, y_1, '.');
	tstr = sprintf('Scatter plot for y[n] vs. y[n+%d]', el);
	title(tstr)
	xlabel('y[n]');
	ystr = sprintf('y[n+%d]', el);
	ylabel(ystr);
end

r_yy = conv(h,h);
L = length(r_yy);
k = -(L-1)/2:1:(L-1)/2;

figure(4);
plot(k,r_yy)
title('Autocorrelation for y[n]');
xlabel('n');
ylabel('r_yy[n]');
