clear all
N = 100
a = 10
n = 1:1:N;
x = randn(1,N);
n = randn(1,N);
snr = a^2
rho_xy = 1./sqrt(1+1./snr)
y = a.*x + n;

figure(1)
plot(x)
title('X data')
xlabel('Sample No. n')
ylabel('X[n]')
gtext('X is i.i.d Gaussian with unit variance and zero mean (N(0,1))')
figure(2)
plot(y)
title('Y data')
xlabel('Sample No. n')
ylabel('Y[n]')
caption = sprintf('Y[n] = a*X[n] + N[n], a = %5.2f, N is i.i.d N(0,1)', a)
gtext(caption)
figure(3)
plot(x,y,'.')
title('Scatter Plot')
xlabel('X[n]')
ylabel('Y[n]')
clear caption
caption = sprintf('Correlation coefficient = %5.2f', rho_xy)
gtext(caption)
