clear all
close all
N = 100
stddev = 1
mu = 1
n = 1:1:N;
x = randn(1,N);
y = stddev.*x + mu;

sum = 0;
sumsq = 0;
for m = 1:N
	sum = sum + y(m);
	sumsq = sumsq + y(m)^2;
	muhat(m) = sum/m;
	varhat = sumsq/m - muhat(m)^2;
	if m > 1
		stddevhat_unb(m) = sqrt(m./(m-1).*varhat);
	else
		stddevhat_unb(m) = sqrt(varhat);
	end
end
figure(1)
plot(n,y,'-.',n,muhat,'-',n,muhat+stddevhat_unb,'--',n,muhat-stddevhat_unb,'--')
title('Estimating mean of a sequence of random variables')
xlabel('Sample No.')
ylabel('Data')
legend('-.','Data','-','Sample Mean','--','Sample Mean +/- Sample Std. Dev.')
gtext('Data is i.i.d. Gaussian with mean 1 and std. dev. 1')
