%--------------------------------------------------------------
% Initialize
%
close all;
clear all;
gain = 0.5;
T = 1.0;
Fs = 10000;
N = Fs*T;
Nplot = 200;
log2N = log(N)/log(2);
ceillog2N = ceil(log2N);
N = 2^ceillog2N
%--------------------------------------------------------------
% Generate signal
%
x = gain*sig_1_gen(T, Fs, N);
%--------------------------------------------------------------
% Put it through the system
%
y = system_1(x);
input('Input signal x followed by output signal y')
sound(x,Fs);
sound(y,Fs);
%--------------------------------------------------------------
% Generate plots
%
figure(1)
subplot(2, 1, 1), plot(x(1:Nplot))
title('System input')
xlabel('n')
ylabel('x[n]')
subplot(2, 1, 2), plot(y(1:Nplot))
title('System output')
xlabel('n')
ylabel('y[n]')
pause
%--------------------------------------------------------------
% Compute spectra
%
X = dtft(x, N);
Y = dtft(y, N);
%--------------------------------------------------------------
% Plot spectra
%
omega = -pi:2*pi/(N-1):pi;
figure(2)
subplot(2, 1, 1), plot(omega, abs(Y))
title('Output spectrum magnitude')
ylabel('|Y(omega)|')
axis([-pi, pi, 0, max(abs(Y))])
subplot(2, 1, 2), plot(omega, abs(X))
title('Input spectrum magnitude')
ylabel('|X(omega)|')
axis([-pi, pi, 0, max(abs(X))])
pause
%--------------------------------------------------------------
% SNR
%
x_sq = x.*x;
P_x = sum(x_sq)/N
e = y-x;
e_sq = e.*e;
P_e = sum(e_sq)/N
SNR = 10*log10(P_x/P_e)
%--------------------------------------------------------------
% Error spectrum
%
E = dtft(e, N);
figure(3)
subplot(2, 1, 1), plot(e(1:Nplot))
title('Error')
xlabel('n')
ylabel('e[n]')
omega = -pi:2*pi/(N-1):pi;
subplot(2, 1, 2), plot(omega, abs(E))
title('Error spectrum magnitude')
ylabel('|E(omega)|')
axis([-pi, pi, 0, max(abs(E))])
pause
%--------------------------------------------------------------
% Null error at fundamental frequencies
%
E_max = max(abs(E));
epsilon = 0.01*E_max;
i_max = find(abs(E) >= E_max - epsilon);
delta = i_max(2) - i_max(1);
mask = ones(1,N);
null = zeros(1,2*delta);
null_start = N/2-delta;
null_stop = null_start + length(null) - 1;
mask(null_start:null_stop) = null;
E_h = mask.*E;
figure(4)
plot(omega, abs(E_h))
title('Error harmonics only')
ylabel('|E_h(omega)|')
axis([-pi, pi, 0, max(abs(E_h))])
X = dtft(x,N);
%--------------------------------------------------------------
% (THD) Total harmonic distortion
%
X = dtft(x,N);
X_sq = abs(X).^2;
P_X = sum(X_sq)/N
E_sq = abs(E_h).^2;
P_E_h = sum(E_sq)/N
THD = (P_E_h/P_X)*100
