% EE 438 Digital Signal Processing with Applications - Spring 1997
% 2-D signals and systems
% Image display within Matlab
%---------------------------------------------------------------
% Initialize
clear all;
close all;
%---------------------------------------------------------------
%Initialize colormap
mcomp = 0 : 1.0 ./ 255 : 1.0; % output colors lie in [0,1]
map = [mcomp' mcomp' mcomp'];

M = 128;  % size of image
M2 = M/2;
X = 8;  % width of rect
X2 = X/2;
rect1d = zeros(M,1);
rect1d(M2-X2+1:M2+X2) = ones(X,1);
g = rect1d*rect1d';
figure(1);
image(g*255);
colormap(map);
axis('off');
axis('image');

g = fftshift(g);
G = fft2(g);
G = fftshift(G);
Gmag = abs(G);
Gmax = max(max(Gmag));
decade = 1.5;
Gmag = Gmag/Gmax*10^decade + 1;
Gmag = log10(Gmag);
Gmax = max(max(Gmag));
figure(2);
image(Gmag*255/Gmax);
colormap(map);
axis('off');
axis('image');
