% EE 438 Digital Signal Processing with Applications - Spring 1997
% 2-D signals and systems
% Image display within Matlab
%---------------------------------------------------------------
% Initialize
clear all;
close all;
%---------------------------------------------------------------
%Initialize colormap
mcomp = 0 : 1.0 ./ 255 : 1.0; % output colors lie in [0,1]
map = [mcomp' mcomp' mcomp'];

M = 128;  % size of image
index = (0:1:M-1);
y = ones(M,1)*index;
x = y';
degrees = 90;
theta = pi*degrees/180;
P = 16;
duty = 0.5;
g = abs(rem(cos(theta)*x + sin(theta)*y, P)) <= duty*P;
figure(1);
image(g*255);
colormap(map);
axis('off');
axis('image');

g = fftshift(g);
G = fft2(g);
G = fftshift(G);
Gmag = abs(G);
Gmax = max(max(G));
figure(2);
image(Gmag*255/Gmax);
colormap(map);
axis('off');
axis('image');

%Limit no. cycles to width W
W = 64;
degrees = 0;
alpha = pi*degrees/180;
g = abs(rem(cos(theta)*x + sin(theta)*y, P)) <= duty*P;
g = g.*(abs(cos(alpha)*(x-M/2+1) + sin(alpha)*(y-M/2+1)) <= W/2);
figure(3);
image(g*255);
colormap(map);
axis('off');
axis('image');

g = fftshift(g);
G = fft2(g);
G = fftshift(G);
Gmag = abs(G);
Gmax = max(max(G));
figure(4);
image(Gmag*255/Gmax);
colormap(map);
axis('off');
axis('image');
