% EE 438 Digital Signal Processing with Applications - Spring 1997
% 2-D signals and systems
% Image display within Matlab
%---------------------------------------------------------------
% Initialize
clear all;
close all;
%---------------------------------------------------------------
%Initialize colormap
mcomp = 0 : 1.0 ./ 255 : 1.0; % output colors lie in [0,1]
map = [mcomp' mcomp' mcomp'];

M = 128;  % size of image
index = (0:1:M-1);
y = ones(M,1)*index;
x = y';
degrees = 30;
theta = pi*degrees/180;
P = 16;
rho = 1/P;
u = rho*cos(theta)
v = rho*sin(theta)
g = 0.5 + 0.5*cos(2*pi*(u*x + v*y));
figure(1);
image(g*255);
colormap(map);
axis('off');
axis('image');

g = fftshift(g);
G = fft2(g);
G = fftshift(G);
Gmag = abs(G);
Gmax = max(max(G));
figure(2);
image(Gmag*255/Gmax);
colormap(map);
axis('off');
axis('image');
