% EE 438 Digital Signal Processing with Applications - Spring 1997
% 2-D signals and systems
% Image display within Matlab
%---------------------------------------------------------------
% Initialize
clear all;
close all;
%---------------------------------------------------------------
%Initialize colormap
mcomp = 0 : 1.0 ./ 255 : 1.0; % output colors lie in [0,1]
map = [mcomp' mcomp' mcomp'];

M = 128;  % size of image
index = (-M/2:1:M/2-1);
y = ones(M,1)*index;
x = y';
radius = 16;
g = x.*x + y.*y <= radius.*radius;
figure(1);
image(g*255);
colormap(map);
axis('off');
axis('image');

g = fftshift(g);
G = fft2(g);
G = fftshift(G);
Gmag = abs(G);
Gmax = max(max(G));
figure(2);
image(Gmag*255/Gmax);
colormap(map);
axis('off');
axis('image');
